/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.common.config.diff;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.jfrog.common.config.diff.DiffAtomic;
import org.jfrog.common.config.diff.DiffFunctions;
import org.jfrog.common.config.diff.DiffIgnore;
import org.jfrog.common.config.diff.DiffInclude;
import org.jfrog.common.config.diff.DiffKey;
import org.jfrog.common.config.diff.DiffReference;
import org.jfrog.common.config.diff.DiffUtils;
import org.jfrog.common.config.diff.GenerateDiffFunction;

@SupportedAnnotationTypes(value={"org.jfrog.common.config.diff.GenerateDiffFunction"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_11)
public class DiffProcessor
extends AbstractProcessor {
    private Elements elementUtils;
    private Types typeUtils;

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.typeUtils = this.processingEnv.getTypeUtils();
        this.elementUtils = this.processingEnv.getElementUtils();
        try {
            Collection<? extends Element> annotatedElements = this.getAnnotatedElementsIfValid(roundEnv);
            if (annotatedElements == null) {
                return false;
            }
            Map<PackageElement, Set<Element>> packageToClassNames = annotatedElements.stream().collect(Collectors.groupingBy(this::getPackage)).entrySet().stream().map(entry -> Pair.of((Object)((PackageElement)entry.getKey()), (Object)ImmutableSet.builder().addAll((Iterable)entry.getValue()).addAll(this.expandPackageElements((PackageElement)entry.getKey())).build())).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
            this.validateReferencedClasses(packageToClassNames, annotatedElements);
            packageToClassNames.forEach(this::generateForPackage);
        }
        catch (FailWithError e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, e.getMessage(), e.element);
            return false;
        }
        return true;
    }

    private Set<? extends Element> expandPackageElements(PackageElement pack) {
        return pack.getEnclosedElements().stream().filter(elem -> elem.getAnnotation(GenerateDiffFunction.class) != null).collect(Collectors.toSet());
    }

    private Collection<? extends Element> getAnnotatedElementsIfValid(RoundEnvironment roundEnv) {
        if (roundEnv.errorRaised()) {
            return null;
        }
        Set<? extends Element> annotatedElements = roundEnv.getElementsAnnotatedWith(GenerateDiffFunction.class);
        if (annotatedElements.size() == 0) {
            return null;
        }
        List<Element> notClassElements = annotatedElements.stream().filter(element -> !element.getKind().isInterface() && !element.getKind().isClass()).collect(Collectors.toList());
        if (notClassElements.size() > 0) {
            notClassElements.forEach(element -> this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Only interfaces or classes are supported for @" + GenerateDiffFunction.class.getSimpleName(), (Element)element));
            return null;
        }
        return annotatedElements;
    }

    private void validateReferencedClasses(Map<PackageElement, Set<Element>> packageToClassNames, Collection<? extends Element> annotatedElements) {
        List elementsNames = annotatedElements.stream().map(elem -> elem.getSimpleName().toString()).collect(Collectors.toList());
        Set duplicates = elementsNames.stream().filter(i -> Collections.frequency(elementsNames, i) > 1).collect(Collectors.toSet());
        if (duplicates.size() > 0) {
            throw new FailWithError("Duplicate class names are found: " + duplicates.toString(), null);
        }
        packageToClassNames.entrySet().stream().map(entry -> Pair.of((Object)((PackageElement)entry.getKey()), ((Set)entry.getValue()).stream().collect(Collectors.toMap(this::elementName, Function.identity())))).sorted(Comparator.comparing(pair -> ((PackageElement)pair.getLeft()).getSimpleName().toString())).forEach(this::validateMissingElementsAnnotations);
    }

    private void validateMissingElementsAnnotations(Pair<PackageElement, Map<String, Element>> packageElements) {
        Map<Element, Set<TypeMirror>> requiredTypes = ((Map)packageElements.getRight()).values().stream().collect(Collectors.toMap(Function.identity(), value -> this.streamOfNotAtomicNotReferenceFieldsTypes((Element)value).collect(Collectors.toSet())));
        this.validateAnnotation(this.packageMissingElements((Map)packageElements.getRight(), requiredTypes));
    }

    private void validateAnnotation(Map<Element, Set<Element>> missingElements) {
        List notAnnotatedElements = missingElements.keySet().stream().filter(element -> element.getAnnotation(GenerateDiffFunction.class) == null).distinct().collect(Collectors.toList());
        if (notAnnotatedElements.size() > 0) {
            throw new FailWithError("Referenced class" + (notAnnotatedElements.size() > 1 ? "es are" : " is") + " not annotated with @" + GenerateDiffFunction.class.getSimpleName() + ". " + notAnnotatedElements.toString() + ". First missing element referenced by class " + missingElements.get(notAnnotatedElements.get(0)) + this.hierarchicalRefs(missingElements, missingElements.get(notAnnotatedElements.get(0))), notAnnotatedElements.stream().findFirst().orElse(null));
        }
    }

    private String hierarchicalRefs(Map<Element, Set<Element>> missingElements, Set<Element> elements) {
        if (elements.stream().noneMatch(missingElements::containsKey)) {
            return "";
        }
        Set<Element> referencedElements = elements.stream().flatMap(elem -> ((Set)missingElements.get(elem)).stream()).collect(Collectors.toSet());
        return ", that was referenced from " + referencedElements.stream().map(Object::toString).collect(Collectors.joining(", ")) + this.hierarchicalRefs(missingElements, referencedElements);
    }

    private Map<Element, Set<Element>> packageMissingElements(Map<String, Element> packageElements, Map<Element, Set<TypeMirror>> requiredTypes) {
        return requiredTypes.entrySet().stream().flatMap(entry -> ((Set)entry.getValue()).stream().map(value -> Pair.of((Object)((Element)entry.getKey()), (Object)value))).filter(refAndType -> !this.isPrimitiveOrSimilar((TypeMirror)refAndType.getRight())).flatMap(this::extractTypeArguments).map(refAndType -> this.pairOfValue((Pair<Element, TypeMirror>)refAndType, this.extractSpecificType((TypeMirror)refAndType.getRight()))).filter(refAndType -> !this.isPrimitiveOrSimilar((TypeMirror)refAndType.getRight())).map(refAndType -> this.pairOfValue((Pair<Element, TypeMirror>)refAndType, this.typeUtils.asElement((TypeMirror)refAndType.getRight()))).filter(refAndElement -> !packageElements.containsKey(((Element)refAndElement.getRight()).getSimpleName().toString())).collect(Collectors.toMap(Pair::getRight, pair -> ImmutableSet.of((Object)((Element)pair.getLeft())), (pair1, pair2) -> ImmutableSet.builder().addAll((Iterable)pair1).addAll((Iterable)pair2).build()));
    }

    private <T> Pair<Element, T> pairOfValue(Pair<Element, TypeMirror> refAndType, T value) {
        return Pair.of((Object)((Element)refAndType.getLeft()), value);
    }

    private Stream<Pair<Element, TypeMirror>> extractTypeArguments(Pair<Element, TypeMirror> refAndType) {
        return this.isMap((TypeMirror)refAndType.getRight()) || this.isCollection((TypeMirror)refAndType.getRight()) ? ((DeclaredType)refAndType.getRight()).getTypeArguments().stream().map(res -> Pair.of((Object)((Element)refAndType.getLeft()), (Object)res)) : Stream.of(refAndType);
    }

    private void generateForPackage(PackageElement pack, Collection<? extends Element> annotatedElements) {
        String className = DiffFunctions.class.getSimpleName() + "Impl";
        StringBuilder source = new StringBuilder();
        ArrayList<String> functionNames = new ArrayList<String>();
        boolean withComponentStereotype = annotatedElements.stream().anyMatch(elem -> elem.getAnnotation(GenerateDiffFunction.class).withComponentStereotype());
        String packageName = pack.getQualifiedName().toString();
        this.addPackageAndImports(source, packageName, annotatedElements, withComponentStereotype);
        this.addClassDefAndBasicMethods(className, source, withComponentStereotype);
        List<String> fields = annotatedElements.stream().flatMap(element -> this.addMethodForAnnotatedClass(source, packageName, (List<String>)functionNames, (Element)element).stream()).distinct().collect(Collectors.toList());
        fields.forEach(field -> source.append("  ").append((String)field).append("\n"));
        DiffProcessor.addConstructor(className, source, functionNames);
        source.append("}\n");
        String filename = pack.getQualifiedName().toString() + "." + className;
        this.writeJavaSource(source, filename);
    }

    private void addPackageAndImports(StringBuilder source, String packageName, Collection<? extends Element> annotatedElements, boolean withComponentStereotype) {
        source.append("package ").append(packageName).append(";\n\n").append("import org.apache.commons.lang3.builder.*;\n").append("import java.util.function.BiFunction;\n").append("import java.util.*;\n").append("import java.util.stream.*;\n").append("import ").append(DiffUtils.class.getName()).append(";\n").append(withComponentStereotype ? "import org.springframework.stereotype.Component;\n" : "").append(annotatedElements.stream().filter(elem -> !packageName.equals(this.getPackageName((Element)elem))).map(elem -> "import " + this.getPackageName((Element)elem) + "." + elem.getSimpleName() + ";").collect(Collectors.joining("\n", "\n", "\n"))).append("import ").append(DiffFunctions.class.getName()).append(";\n\n");
    }

    private void addClassDefAndBasicMethods(String className, StringBuilder source, boolean withComponentStereotype) {
        source.append(withComponentStereotype ? "@Component\n" : "").append("public class ").append(className).append(" implements DiffFunctions").append("{\n").append("  Map<String, BiFunction<Object, Object, DiffResult>> diffFunctions = new HashMap<>();\n").append("  @Override\n  public <T> DiffResult diffFor(Class<T> c, T object, T other) {\n").append("    return diffFunctions.get(c.getSimpleName()).apply(object, other);\n").append("  }\n\n").append("  @Override\n  public <T> boolean containsClass(Class<T> c) {\n").append("    return diffFunctions.containsKey(c.getSimpleName());\n").append("  }\n\n");
    }

    private static void addConstructor(String className, StringBuilder source, List<String> functionNames) {
        source.append("  public ").append(className).append("() {").append(functionNames.stream().map(object -> "diffFunctions.put(\"" + object + "\", (object, other) -> " + DiffUtils.toFieldName(object) + "((" + object + ")object, (" + object + ")other));").collect(Collectors.joining("\n    ", "\n    ", "\n"))).append("  }\n\n");
    }

    private List<String> addMethodForAnnotatedClass(StringBuilder source, String packageName, List<String> functionNames, Element element) {
        String functionName = element.getSimpleName().toString();
        functionNames.add(functionName);
        StringBuilder diffSourceBuilder = new StringBuilder();
        diffSourceBuilder.append("  private DiffResult ").append(DiffUtils.toFieldName(functionName)).append("(").append(functionName).append(" object").append(", ").append(functionName).append(" other) {\n");
        ArrayList<String> fieldsToAppend = new ArrayList();
        if (element.getAnnotation(GenerateDiffFunction.class).internalDiff()) {
            this.addInternalCallToMethod(diffSourceBuilder);
        } else {
            fieldsToAppend = this.generateDiffMethodContentForMethods(diffSourceBuilder, packageName, element);
        }
        diffSourceBuilder.append("  }\n");
        source.append((CharSequence)diffSourceBuilder);
        return fieldsToAppend;
    }

    private Set<VariableElement> relevantFieldsInElement(Element element) {
        return this.notDistinctFieldsInElement(element).stream().filter(field -> field.getAnnotation(DiffIgnore.class) == null).filter(DiffProcessor.distinctByKey(e -> e.getSimpleName().toString())).collect(Collectors.toSet());
    }

    private Set<VariableElement> notDistinctFieldsInElement(Element element) {
        block3: {
            block2: {
                if (element == null) break block2;
                if (Stream.of("Object", "Enum").anyMatch(element.getSimpleName().toString()::equals)) break block2;
                if (!Stream.of(ElementKind.CLASS, ElementKind.ENUM, ElementKind.INTERFACE).noneMatch(element.getKind()::equals)) break block3;
            }
            return ImmutableSet.of();
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        List currentTypeFields = this.filterAndSortFields(ElementFilter.fieldsIn(element.getEnclosedElements())).collect(Collectors.toList());
        Set currentTypeFieldsNames = currentTypeFields.stream().map(VariableElement::getSimpleName).map(Object::toString).collect(Collectors.toSet());
        this.typeUtils.directSupertypes(element.asType()).stream().map(this.typeUtils::asElement).map(this::notDistinctFieldsInElement).flatMap(Collection::stream).filter(field -> !currentTypeFieldsNames.contains(field.getSimpleName().toString())).forEach(arg_0 -> ((ImmutableSet.Builder)builder).add(arg_0));
        builder.addAll(currentTypeFields);
        return builder.build();
    }

    private static <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        ConcurrentHashMap seen = new ConcurrentHashMap();
        return t -> seen.putIfAbsent(keyExtractor.apply(t), Boolean.TRUE) == null;
    }

    private List<String> generateDiffMethodContentForMethods(StringBuilder source, String packageName, Element element) {
        source.append("    DiffBuilder db = new DiffBuilder(object, other, ToStringStyle.DEFAULT_STYLE, false);\n");
        List<String> fields = this.filterAndSortFields(this.relevantFieldsInElement(element)).map(field -> this.fieldToLocalDiffMethod(packageName, (VariableElement)field)).peek(sourceAndFields -> source.append((String)sourceAndFields.getLeft())).map(Pair::getRight).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
        source.append("    return db.build();\n");
        return fields;
    }

    private Stream<VariableElement> filterAndSortFields(Collection<VariableElement> fields) {
        boolean diffIncludePresent = fields.stream().anyMatch(m -> m.getAnnotation(DiffInclude.class) != null);
        return fields.stream().filter(field -> !diffIncludePresent || field.getAnnotation(DiffInclude.class) != null).filter(field -> field.getModifiers().stream().noneMatch(Modifier.STATIC::equals)).sorted(Comparator.comparing(e -> e.getSimpleName().toString()));
    }

    private void addInternalCallToMethod(StringBuilder source) {
        source.append("    return object.diff(other);");
    }

    private Pair<String, String> fieldToLocalDiffMethod(String packageName, VariableElement field) {
        TypeMirror returnType = field.asType();
        String methodName = field.getSimpleName().toString();
        if (this.isPrimitiveOrSimilar(returnType) || field.getAnnotation(DiffAtomic.class) != null || field.getAnnotation(DiffReference.class) != null || this.isCollectionOrMapOfPrimitive(returnType)) {
            return this.simpleAppend(field, methodName, DiffUtils.toMethodName(methodName, this.isBoolean(returnType)));
        }
        return this.diffMethodForComplexClass(packageName, field);
    }

    private boolean isCollectionOrMapOfPrimitive(TypeMirror returnType) {
        if (this.isMap(returnType)) {
            return this.isPrimitiveOrSimilar(((DeclaredType)returnType).getTypeArguments().get(1));
        }
        return this.isCollection(returnType) && this.isPrimitiveOrSimilar(((DeclaredType)returnType).getTypeArguments().get(0));
    }

    private Pair<String, String> simpleAppend(VariableElement field, String fieldName, String methodName) {
        return this.simpleAppend(field, fieldName, "object." + methodName + "()", "other." + methodName + "()");
    }

    private Pair<String, String> simpleAppend(VariableElement field, String fieldName, String firstArgumentExtractor, String secondArgumentExtractor) {
        return Pair.of((Object)("    db.append(\"" + fieldName + "\", " + this.appendKeyMethodExecution(firstArgumentExtractor, field) + ", " + this.appendKeyMethodExecution(secondArgumentExtractor, field) + ");\n"), null);
    }

    private Pair<String, String> diffMethodForComplexClass(String packageName, VariableElement field) {
        String fieldToAdd;
        String fieldName = field.getSimpleName().toString();
        TypeMirror returnType = this.extractSpecificType(field.asType());
        String methodName = DiffUtils.toMethodName(fieldName, this.isBoolean(returnType));
        Optional<ExecutableElement> method = ElementFilter.methodsIn(field.getEnclosingElement().getEnclosedElements()).stream().filter(m -> m.getSimpleName().toString().equals(methodName)).findFirst();
        Object cast = "";
        if (method.isPresent()) {
            TypeMirror methodReturnType = method.get().getReturnType();
            if (!methodReturnType.equals(returnType)) {
                cast = "(" + returnType.toString() + ")";
            }
        } else {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Couldn't find method for field " + fieldName + " in class " + field.getEnclosingElement().getSimpleName().toString() + ". Not casting to method return type.");
        }
        if (ElementKind.ENUM.equals((Object)this.typeUtils.asElement(returnType).getKind())) {
            String enumMethod = this.typeUtils.asElement(returnType).getAnnotation(GenerateDiffFunction.class).typeMethod();
            return this.simpleAppend(field, fieldName, "object." + methodName + "() == null ? \"\" : object." + methodName + "()." + enumMethod + "()", "other." + methodName + "() == null ? \"\" : other." + methodName + "()." + enumMethod + "()");
        }
        StringBuilder diffMethod = new StringBuilder();
        diffMethod.append("\n    ").append("DiffUtils.appendDiffResult(db, \"").append(fieldName).append("\", ");
        boolean isCollection = false;
        if (this.isMap(returnType) || (isCollection = this.isCollection(returnType))) {
            fieldToAdd = this.diffMethodForMapOrCollection(packageName, returnType, diffMethod, methodName, isCollection);
        } else {
            fieldToAdd = this.diffMethodForObjectOrPrimitive(packageName, returnType, diffMethod);
            diffMethod.append("\n        ").append((String)cast).append(" ").append("object.").append(methodName).append("()").append(", \n       ").append((String)cast).append(" ").append("other.").append(methodName).append("()").append("));\n");
        }
        return Pair.of((Object)diffMethod.toString(), (Object)fieldToAdd);
    }

    private String appendKeyMethodExecution(String toWrap, VariableElement field) {
        if (field.getAnnotation(DiffReference.class) != null) {
            String prefix = "Objects.isNull(" + toWrap + ") ? null : " + toWrap + ".";
            TypeMirror fieldType = field.asType();
            String methodName = DiffUtils.toMethodName(this.findKeyExtractorMethod(fieldType), false);
            if (this.isCollection(fieldType)) {
                return prefix + "stream()\n      .map(v -> v." + methodName + "())\n      .collect(Collectors.toList())";
            }
            return prefix + methodName + "()";
        }
        return toWrap;
    }

    private String diffMethodForObjectOrPrimitive(String packageName, TypeMirror returnType, StringBuilder diffMethod) {
        Element returnTypeElement = this.typeUtils.asElement(returnType);
        diffMethod.append("\n        DiffUtils.diffInternalClass(");
        String newField = null;
        if (!this.isPrimitiveOrSimilar(returnType) && !packageName.equals(this.getPackageName(returnTypeElement))) {
            String fieldName = DiffUtils.toFieldName(this.getPackageName(returnTypeElement));
            newField = this.fieldForPackage(fieldName, returnTypeElement);
            diffMethod.append(fieldName).append(",").append("\n        ").append(this.getPackageName(returnTypeElement)).append(".").append(returnTypeElement.getSimpleName().toString()).append(".class, ");
        } else {
            diffMethod.append("this,").append("\n        ").append(returnTypeElement.getSimpleName().toString()).append(".class, ");
        }
        return newField;
    }

    private String diffMethodForMapOrCollection(String packageName, TypeMirror returnType, StringBuilder diffMethod, String methodName, boolean isCollection) {
        TypeMirror erasureType = this.findErasure(returnType);
        TypeMirror extractedType = this.extractSpecificType(erasureType);
        String erasureName = "Object";
        String diffFunctions = "this";
        String newField = null;
        String cast = "";
        if (erasureType != null) {
            Element erasureTypeElement = this.typeUtils.asElement(this.removeWildcard(extractedType));
            if (!this.isPrimitiveOrSimilar(erasureType) && !packageName.equals(this.getPackageName(erasureTypeElement))) {
                diffFunctions = DiffUtils.toFieldName(this.getPackageName(erasureTypeElement));
                newField = this.fieldForPackage(diffFunctions, erasureTypeElement);
            }
            if (!erasureType.equals(extractedType)) {
                cast = isCollection ? "(Collection)" : "(Map)";
            }
            erasureName = ((TypeElement)erasureTypeElement).getQualifiedName().toString();
        }
        diffMethod.append("\n        ").append("DiffUtils.diff").append(isCollection ? "Collection" : "Map").append("(").append(diffFunctions).append(",\n        ").append(erasureName);
        diffMethod.append(".class, ");
        if (isCollection) {
            diffMethod.append((String)(erasureType == null || this.isPrimitiveOrSimilar(erasureType) ? "Object::toString, " : "v -> v." + DiffUtils.toMethodName(this.findKeyExtractorMethod(extractedType), false) + "(), "));
        }
        diffMethod.append("\n        ").append(cast).append("object.").append(methodName).append("(),").append(cast).append("other.").append(methodName).append("()").append("));\n");
        return newField;
    }

    private String fieldForPackage(String normalizedPackageName, Element element) {
        return "private " + DiffFunctions.class.getSimpleName() + " " + normalizedPackageName + " = new " + this.getPackageName(element) + "." + DiffFunctions.class.getSimpleName() + "Impl();";
    }

    private TypeMirror findErasure(TypeMirror type) {
        if (!(type instanceof DeclaredType)) {
            return null;
        }
        DeclaredType declaredType = (DeclaredType)type;
        boolean isCollection = this.isCollection(declaredType);
        TypeMirror erasureType = null;
        if (declaredType.getTypeArguments().size() >= (isCollection ? 1 : 2)) {
            erasureType = declaredType.getTypeArguments().get(isCollection ? 0 : 1);
        }
        return erasureType;
    }

    private TypeMirror removeWildcard(TypeMirror type) {
        return type.getKind() == TypeKind.WILDCARD ? ((WildcardType)type).getExtendsBound() : type;
    }

    private TypeMirror extractSpecificType(TypeMirror type) {
        if (type == null) {
            return null;
        }
        TypeMirror specificType = this.removeWildcard(type);
        return this.typeUtils.asElement(specificType).getAnnotationMirrors().stream().filter(a -> a.getAnnotationType().toString().equals(GenerateDiffFunction.class.getName())).findFirst().map(annotation -> annotation.getElementValues().entrySet().stream().filter(entry -> "defaultImpl".equals(((ExecutableElement)entry.getKey()).getSimpleName().toString())).map(Map.Entry::getValue).map(AnnotationValue::getValue).filter(val -> !val.equals(Object.class.getName())).findFirst().map(val -> this.elementUtils.getTypeElement(val.toString()).asType()).orElse(specificType)).orElse(specificType);
    }

    private String findKeyExtractorMethod(TypeMirror type) {
        TypeMirror extractedType = this.extractSpecificType(this.isCollection(type) ? this.findErasure(type) : type);
        return this.relevantFieldsInElement(this.typeUtils.asElement(extractedType)).stream().filter(field -> field.getAnnotation(DiffKey.class) != null).map(method -> method.getSimpleName().toString()).findFirst().orElseThrow(() -> new FailWithError("Classes that are referenced as List or by @" + DiffReference.class.getSimpleName() + " must define a method with @" + DiffKey.class.getSimpleName() + ". [" + type + "]", this.typeUtils.asElement(type)));
    }

    private String elementName(Element elem) {
        return elem.getSimpleName().toString();
    }

    private Stream<TypeMirror> streamOfNotAtomicNotReferenceFieldsTypes(Element element) {
        return this.relevantFieldsInElement(element).stream().filter(varType -> varType.getAnnotation(DiffAtomic.class) == null).filter(varType -> varType.getAnnotation(DiffReference.class) == null).map(Element::asType);
    }

    private PackageElement getPackage(Element elem) {
        return (PackageElement)elem.getEnclosingElement();
    }

    private String getPackageName(Element elem) {
        return this.getPackage(elem).getQualifiedName().toString();
    }

    private boolean isCollection(TypeMirror returnType) {
        DeclaredType wildcardList = this.typeUtils.getDeclaredType(this.elementUtils.getTypeElement(Collection.class.getName()), this.typeUtils.getWildcardType(null, null));
        return this.typeUtils.isAssignable(returnType, wildcardList);
    }

    private boolean isBoolean(TypeMirror returnType) {
        return returnType.getKind().equals((Object)TypeKind.BOOLEAN);
    }

    private boolean isPrimitiveOrSimilar(TypeMirror returnType) {
        TypeMirror typeToCheck = returnType.getKind() != TypeKind.ARRAY ? returnType : ((ArrayType)returnType).getComponentType();
        return returnType.getKind().isPrimitive() || Stream.of(String.class, Long.class, Integer.class, Boolean.class).anyMatch(type -> this.isType(typeToCheck, (Class<?>)type));
    }

    private boolean isMap(TypeMirror returnType) {
        DeclaredType wildcardMap = this.typeUtils.getDeclaredType(this.elementUtils.getTypeElement(Map.class.getName()), this.typeUtils.getWildcardType(null, null), this.typeUtils.getWildcardType(null, null));
        return this.typeUtils.isAssignable(returnType, wildcardMap);
    }

    private boolean isType(TypeMirror returnType, Class<?> c) {
        return this.typeUtils.isSameType(returnType, this.elementUtils.getTypeElement(c.getName()).asType());
    }

    private void writeJavaSource(StringBuilder builder, CharSequence className) {
        try {
            JavaFileObject javaFileObject = this.processingEnv.getFiler().createSourceFile(className, new Element[0]);
            Writer writer = javaFileObject.openWriter();
            writer.write(builder.toString());
            writer.close();
        }
        catch (IOException e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Couldn't write java source file to " + className + ". " + e.getMessage());
            e.printStackTrace();
        }
    }

    private class FailWithError
    extends RuntimeException {
        private Element element;

        FailWithError(String message, Element element) {
            super(message);
            this.element = element;
        }
    }
}

