package org.jfrog.common.config.diff;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Mark a field in diffable bean as the primary key if the bean is part of a collection in one of its containers
 * When comparing a collection, the diff engine automagically converts collections to maps, for that it needs to
 * understand what is the key in the map which is marked by this annotation.
 *
 * @author Noam Shemesh
 */
@Target(ElementType.FIELD)
@Retention(RetentionPolicy.RUNTIME)
public @interface DiffKey {
}
