package org.jfrog.common.config.diff;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * When using this annotation for one field in the bean, the bean fields discovery strategy automatically changed to
 * white list instead of black list (@DiffIgnore).
 * Use this to mark a field in white listed bean as "diffable"
 *
 * @author Noam Shemesh
 */
@Target(ElementType.FIELD)
@Retention(RetentionPolicy.SOURCE)
public @interface DiffInclude {
}
