/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.common.config.diff;

import com.google.common.eventbus.EventBus;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.Diff;
import org.apache.commons.lang3.builder.DiffBuilder;
import org.apache.commons.lang3.builder.DiffResult;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.commons.lang3.text.WordUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.jfrog.common.config.diff.DiffFunctions;

public abstract class DiffUtils {
    public static final String NEW_MARKER = "$$new";
    public static final String DELETED_MARKER = "$$deleted";
    public static final String DELIMITER = "\u00bb";

    private DiffUtils() {
    }

    public static <T> DiffResult diffMap(DiffFunctions diffFunctions, Class<T> c, Map<String, ? extends T> lhs, Map<String, ? extends T> rhs) {
        Map<String, Object> localRhs = rhs != null ? rhs : Collections.emptyMap();
        Map<String, Object> localLhs = lhs != null ? lhs : Collections.emptyMap();
        DiffBuilder db = new DiffBuilder(localLhs, localRhs, ToStringStyle.DEFAULT_STYLE, false);
        localLhs.forEach((key, lhsValue) -> DiffUtils.diffByType(diffFunctions, c, localRhs, db, key, lhsValue));
        localRhs.keySet().stream().filter(k -> !localLhs.containsKey(k)).forEach(key -> DiffUtils.diffByType(diffFunctions, c, localRhs, db, key, null));
        return db.build();
    }

    private static <T> void diffByType(DiffFunctions diffFunctions, Class<T> c, Map<String, ? extends T> localRhs, DiffBuilder db, String key, T lhs) {
        if (diffFunctions.containsClass(c)) {
            DiffUtils.appendDiffResult(db, key, DiffUtils.diffInternalClass(diffFunctions, c, lhs, localRhs.get(key)));
        } else {
            db.append(key, lhs, localRhs.get(key));
        }
    }

    public static <T> DiffResult diffCollection(DiffFunctions diffFunctions, Class<T> c, Function<T, Object> keyExtractor, Collection<? extends T> lhs, Collection<? extends T> rhs) {
        Collection<T> localLhs = lhs != null ? lhs : Collections.emptyList();
        Collection<T> localRhs = rhs != null ? rhs : Collections.emptyList();
        Function<Object, String> keyToString = t -> "" + keyExtractor.apply(t);
        return DiffUtils.diffMap(diffFunctions, c, localLhs.stream().collect(Collectors.toMap(keyToString, Function.identity())), localRhs.stream().collect(Collectors.toMap(keyToString, Function.identity())));
    }

    public static <T> DiffResult diffInternalClass(DiffFunctions diffFunctions, Class<T> c, T lhs, T rhs) {
        if (lhs == null || rhs == null) {
            return new DiffBuilder(DiffUtils.emptyOrNotEmpty(lhs), DiffUtils.emptyOrNotEmpty(rhs), ToStringStyle.DEFAULT_STYLE, false).append(lhs == null ? NEW_MARKER : DELETED_MARKER, lhs, rhs).build();
        }
        return diffFunctions.diffFor(c, lhs, rhs);
    }

    private static Optional<Object> emptyOrNotEmpty(Object object) {
        return Optional.ofNullable(object);
    }

    public static DiffBuilder appendDiffResult(DiffBuilder diffBuilder, String fieldName, DiffResult diffResult) {
        DiffUtils.validateFieldNameNotNull(fieldName);
        Validate.isTrue((diffResult != null ? 1 : 0) != 0, (String)"Diff result cannot be null", (Object[])new Object[0]);
        for (Diff diff : diffResult.getDiffs()) {
            diffBuilder.append(DiffUtils.getDiffKey(fieldName, diff.getFieldName()), diff.getLeft(), diff.getRight());
        }
        return diffBuilder;
    }

    public static <T> DiffResult diffCasted(DiffFunctions diffFunctions, Class<T> castTo, Pair<? super T, ? super T> toCompare) {
        if (toCompare.getLeft() != null && !castTo.isInstance(toCompare.getLeft()) || toCompare.getRight() != null && !castTo.isInstance(toCompare.getRight())) {
            throw new IllegalStateException("Couldn't cast object to " + castTo);
        }
        return DiffUtils.diffInternalClass(diffFunctions, castTo, castTo.cast(toCompare.getLeft()), castTo.cast(toCompare.getRight()));
    }

    public static <T> Map<String, Set<T>> diffForField(Collection<T> diffs, Function<T, String> getFieldName) {
        return DiffUtils.hierarchicalPaths(diffs, getFieldName);
    }

    private static String getDiffKey(String fieldName, String key) {
        return fieldName + DELIMITER + key;
    }

    private static void validateFieldNameNotNull(String fieldName) {
        Validate.isTrue((fieldName != null ? 1 : 0) != 0, (String)"Field name cannot be null", (Object[])new Object[0]);
    }

    public static <T> void notifyHierarchicalEventBusIfPresent(Map<String, EventBus> eventBuses, DiffResult changes, Function<Collection<Diff<?>>, T> computeDiffResult) {
        DiffUtils.hierarchicalPaths(changes.getDiffs(), Diff::getFieldName).forEach((key, diffList) -> Optional.ofNullable((EventBus)eventBuses.get(key)).ifPresent(value -> value.post(computeDiffResult.apply((Collection<Diff<?>>)diffList))));
    }

    public static <T> Map<String, Set<T>> hierarchicalPaths(Collection<T> changes, Function<T, String> getFieldName) {
        return changes.stream().flatMap(diff -> DiffUtils.extractAllParents(diff, getFieldName)).reduce(new HashMap(), DiffUtils::appendPath, DiffUtils::combinePaths);
    }

    private static <T> Map<String, Set<T>> appendPath(Map<String, Set<T>> allPaths, Map.Entry<String, T> currPath) {
        allPaths.computeIfAbsent(currPath.getKey(), a -> new HashSet()).add(currPath.getValue());
        return allPaths;
    }

    private static <T> Map<String, Set<T>> combinePaths(Map<String, Set<T>> allPaths1, Map<String, Set<T>> allPaths2) {
        HashMap<String, Set<T>> accRes = new HashMap<String, Set<T>>();
        accRes.putAll(allPaths1);
        accRes.putAll(allPaths2);
        return accRes;
    }

    private static <T> Stream<Map.Entry<String, T>> extractAllParents(T diff, Function<T, String> getFieldName) {
        HashMap<String, T> diffs = new HashMap<String, T>();
        String fullName = getFieldName.apply(diff);
        diffs.put(fullName, diff);
        int i = 0;
        int prev = fullName.length();
        while ((i = fullName.lastIndexOf(DELIMITER, prev)) > 0) {
            diffs.put(fullName.substring(0, i), diff);
            prev = i - 1;
        }
        return diffs.entrySet().stream();
    }

    public static String toFieldName(String method) {
        String noGet = method.replaceFirst("^(get|is)", "");
        return StringUtils.uncapitalize((String)WordUtils.capitalize((String)noGet.replace(".", " ")).replace(" ", ""));
    }

    public static String toMethodName(String fieldName, boolean isPrefix) {
        return (isPrefix ? "is" : "get") + StringUtils.capitalize((String)fieldName);
    }

    public static Method fieldToMethod(Field field) {
        try {
            return field.getDeclaringClass().getMethod(DiffUtils.toMethodName(field.getName(), DiffUtils.isBoolean(field)), new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
    }

    public static Field methodToField(Method method) {
        try {
            return method.getDeclaringClass().getDeclaredField(DiffUtils.toFieldName(method.getName()));
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException(e);
        }
    }

    public static boolean isBoolean(Field field) {
        return Boolean.class.equals((Object)ClassUtils.primitiveToWrapper(field.getType()));
    }

    public static boolean isLeafChanged(String fieldName, String fieldToFind) {
        return fieldName.endsWith(fieldToFind);
    }
}

