/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.retention;

import java.io.IOException;
import java.util.Calendar;
import org.apache.commons.lang.StringUtils;
import org.jfrog.build.api.Build;
import org.jfrog.build.api.BuildRetention;
import org.jfrog.build.client.ArtifactoryHttpClient;
import org.jfrog.build.client.ArtifactoryVersion;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryClientConfiguration;
import org.jfrog.build.extractor.clientConfiguration.client.ArtifactoryBuildInfoClient;
import org.jfrog.build.util.VersionException;

public class Utils {
    private static BuildRetention getBuildRetention(ArtifactoryClientConfiguration clientConf) {
        String[] notToDelete;
        int minimumDays;
        String buildRetentionMinimumDays;
        BuildRetention buildRetention = new BuildRetention(clientConf.info.isDeleteBuildArtifacts().booleanValue());
        if (clientConf.info.getBuildRetentionCount() != null) {
            buildRetention.setCount(clientConf.info.getBuildRetentionCount().intValue());
        }
        if (StringUtils.isNotBlank((String)(buildRetentionMinimumDays = clientConf.info.getBuildRetentionMinimumDate())) && (minimumDays = Integer.parseInt(buildRetentionMinimumDays)) > -1) {
            Calendar calendar = Calendar.getInstance();
            calendar.add(6, -minimumDays);
            buildRetention.setMinimumBuildDate(calendar.getTime());
        }
        for (String notToDel : notToDelete = clientConf.info.getBuildNumbersNotToDelete()) {
            buildRetention.addBuildNotToBeDiscarded(notToDel);
        }
        return buildRetention;
    }

    private static void addRetentionIfNeeded(Build build, BuildRetention retention, ArtifactoryVersion version) {
        if (!version.isAtLeast(ArtifactoryHttpClient.STANDALONE_BUILD_RETENTION_SUPPORTED_ARTIFACTORY_VERSION)) {
            build.setBuildRetention(retention);
        }
    }

    private static void sendRetentionIfNeeded(ArtifactoryBuildInfoClient client, BuildRetention retention, String buildName, ArtifactoryVersion version, boolean async) throws IOException {
        if (version.isAtLeast(ArtifactoryHttpClient.STANDALONE_BUILD_RETENTION_SUPPORTED_ARTIFACTORY_VERSION)) {
            client.sendBuildRetetion(retention, ArtifactoryHttpClient.encodeUrl((String)buildName), async);
        }
    }

    public static void sendBuildAndBuildRetention(ArtifactoryBuildInfoClient client, Build build, ArtifactoryClientConfiguration clientConf) throws IOException {
        BuildRetention retention = Utils.getBuildRetention(clientConf);
        Utils.sendBuildAndBuildRetention(client, build, retention, clientConf.info.isAsyncBuildRetention());
    }

    public static void sendBuildAndBuildRetention(ArtifactoryBuildInfoClient client, Build build, BuildRetention retention, boolean asyncBuildRetention) throws IOException {
        ArtifactoryVersion version;
        if (retention == null || retention.isEmpty()) {
            client.sendBuildInfo(build);
            return;
        }
        try {
            version = client.verifyCompatibleArtifactoryVersion();
        }
        catch (VersionException e) {
            throw new RuntimeException(e);
        }
        Utils.addRetentionIfNeeded(build, retention, version);
        client.sendBuildInfo(build);
        Utils.sendRetentionIfNeeded(client, retention, build.getName(), version, asyncBuildRetention);
    }
}

