/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.clientConfiguration.util.spec;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.jfrog.build.extractor.clientConfiguration.util.FileCollectionUtil;
import org.jfrog.build.extractor.clientConfiguration.util.PathsUtils;

public class UploadSpecHelper {
    public static String wildcardCalculateTargetPath(String targetPattern, File artifactFile) {
        if (targetPattern.endsWith("/") || targetPattern.equals("")) {
            return targetPattern + UploadSpecHelper.calculateTargetRelativePath(artifactFile);
        }
        return targetPattern;
    }

    public static String calculateTargetRelativePath(File artifactFile) {
        String relativePath = artifactFile.getAbsolutePath();
        String parentDir = artifactFile.getParent();
        if (!StringUtils.isBlank((String)parentDir)) {
            relativePath = StringUtils.removeStart((String)artifactFile.getAbsolutePath(), (String)parentDir);
        }
        relativePath = FilenameUtils.separatorsToUnix((String)relativePath);
        relativePath = StringUtils.removeStart((String)relativePath, (String)"/");
        return relativePath;
    }

    public static Multimap<String, File> buildPublishingData(File workspaceDir, String pattern, String[] excludePatterns, String targetPath, boolean flat, boolean recursive, boolean regexp) throws IOException {
        List<File> matchedFiles;
        boolean isAbsolutePath = new File(pattern).isAbsolute();
        if (regexp) {
            matchedFiles = UploadSpecHelper.collectMatchedFilesByRegexp(workspaceDir, pattern, excludePatterns, recursive);
        } else {
            matchedFiles = UploadSpecHelper.collectMatchedFilesByWildcard(workspaceDir, pattern, excludePatterns, recursive);
            pattern = PathsUtils.pathToRegExp(pattern);
        }
        return UploadSpecHelper.getUploadPathsMap(matchedFiles, workspaceDir, targetPath, flat, Pattern.compile(pattern), isAbsolutePath);
    }

    private static List<File> collectMatchedFilesByRegexp(File workspaceDir, String pattern, String[] excludePatterns, boolean recursive) throws IOException {
        String baseDir = UploadSpecHelper.getRegexBaseDir(workspaceDir, pattern);
        String newPattern = UploadSpecHelper.prepareRegexPattern(workspaceDir, pattern, baseDir);
        List<String> candidatePaths = FileCollectionUtil.collectFiles(baseDir, newPattern, recursive, true);
        return UploadSpecHelper.getMatchedFiles(baseDir, newPattern, workspaceDir.getAbsolutePath(), UploadSpecHelper.prepareExcludePattern(excludePatterns, false, recursive), candidatePaths);
    }

    private static List<File> collectMatchedFilesByWildcard(File workspaceDir, String pattern, String[] excludePatterns, boolean recursive) {
        String baseDir = UploadSpecHelper.getWildcardBaseDir(workspaceDir, pattern);
        String newPattern = UploadSpecHelper.prepareWildcardPattern(workspaceDir, pattern, baseDir);
        List<String> candidatePaths = FileCollectionUtil.collectFiles(baseDir, newPattern, recursive, false);
        newPattern = PathsUtils.pathToRegExp(newPattern);
        return UploadSpecHelper.getMatchedFiles(baseDir, newPattern, workspaceDir.getAbsolutePath(), UploadSpecHelper.prepareExcludePattern(excludePatterns, true, recursive), candidatePaths);
    }

    private static List<File> getMatchedFiles(String baseDir, String newPattern, String workspacePath, String excludePattern, List<String> candidatePaths) {
        ArrayList<File> matchedFiles = new ArrayList<File>();
        Pattern regexPattern = Pattern.compile(newPattern);
        Pattern regexExcludePattern = StringUtils.isBlank((String)excludePattern) ? null : Pattern.compile(excludePattern);
        File baseDirFile = new File(baseDir);
        for (String path : candidatePaths) {
            File file = new File(path);
            String relativePath = UploadSpecHelper.getRelativePath(baseDirFile, file).replace("\\", "/");
            if (!regexPattern.matcher(relativePath).matches()) continue;
            if (regexExcludePattern != null) {
                String relativeToWsPath;
                boolean fileInWs = file.getAbsolutePath().startsWith(workspacePath);
                String string = relativeToWsPath = fileInWs ? UploadSpecHelper.getRelativeToWsPath(file.getAbsolutePath(), workspacePath) : file.getAbsolutePath();
                if (regexExcludePattern.matcher(relativeToWsPath).matches()) continue;
            }
            matchedFiles.add(file.getAbsoluteFile());
        }
        return matchedFiles;
    }

    private static String getRelativeToWsPath(String absolutePath, String workspacePath) {
        String absoluteFilePath = absolutePath.replace("\\", "/");
        workspacePath = workspacePath.replace("\\", "/");
        return absoluteFilePath.substring(workspacePath.length() + 1);
    }

    private static String prepareExcludePattern(String[] excludePatterns, boolean isWildcard, boolean recursive) {
        StringBuilder patternSb = new StringBuilder();
        if (!ArrayUtils.isEmpty((Object[])excludePatterns)) {
            for (String pattern : excludePatterns) {
                if (StringUtils.isBlank((String)pattern)) continue;
                if (isWildcard) {
                    pattern = PathsUtils.pathToRegExp(pattern);
                }
                if (recursive && pattern.endsWith(File.pathSeparator)) {
                    pattern = pattern + ".*";
                }
                patternSb.append("(").append(pattern).append(")|");
            }
            if (patternSb.length() > 0) {
                patternSb.deleteCharAt(patternSb.length() - 1);
            }
        }
        return patternSb.toString();
    }

    public static Multimap<String, File> getUploadPathsMap(List<File> files, File workspaceDir, String targetPath, boolean flat, Pattern regexPattern, boolean absolutePath) {
        HashMultimap filePathsMap = HashMultimap.create();
        boolean isTargetDirectory = StringUtils.endsWith((String)targetPath, (String)"/");
        for (File file : files) {
            String sourcePath;
            String fileTargetPath = targetPath;
            if (isTargetDirectory && !flat) {
                fileTargetPath = UploadSpecHelper.calculateFileTargetPath(workspaceDir, file, targetPath);
            }
            if (absolutePath) {
                if (!flat) {
                    fileTargetPath = isTargetDirectory ? targetPath + file.getPath() : targetPath;
                }
                sourcePath = file.getPath();
            } else {
                sourcePath = UploadSpecHelper.getRelativePath(workspaceDir, file);
            }
            fileTargetPath = PathsUtils.reformatRegexp(sourcePath, fileTargetPath.replace('\\', '/'), regexPattern);
            filePathsMap.put((Object)fileTargetPath, (Object)file);
        }
        return filePathsMap;
    }

    private static String getWildcardBaseDir(File workspaceDir, String pattern) {
        String baseDir = UploadSpecHelper.getWildcardAbsolutePattern(workspaceDir, pattern);
        baseDir = StringUtils.substringBefore((String)baseDir, (String)"*");
        baseDir = StringUtils.substringBefore((String)baseDir, (String)"?");
        baseDir = baseDir.substring(0, baseDir.lastIndexOf("/") + 1);
        baseDir = UploadSpecHelper.removeParenthesis(baseDir);
        return UploadSpecHelper.removeParenthesisEscapeChar(baseDir);
    }

    private static String getRegexBaseDir(File workspaceDir, String pattern) throws FileNotFoundException {
        String baseDir = UploadSpecHelper.getRegexpAbsolutePattern(workspaceDir, pattern);
        if (StringUtils.isEmpty((String)(baseDir = UploadSpecHelper.getExistingPath(baseDir)))) {
            throw new FileNotFoundException("Could not find any base path in the pattern: " + pattern);
        }
        if (!baseDir.endsWith("/")) {
            baseDir = baseDir + "/";
        }
        return baseDir;
    }

    private static String prepareRegexPattern(File workspaceDir, String pattern, String baseDir) {
        String absolutePattern = UploadSpecHelper.getRegexpAbsolutePattern(workspaceDir, pattern);
        String newPattern = UploadSpecHelper.cleanRegexpPattern(absolutePattern, baseDir);
        newPattern = UploadSpecHelper.removeLeadingSeparator(newPattern);
        if (pattern.endsWith("/")) {
            newPattern = newPattern + ".*";
        }
        return newPattern;
    }

    private static String prepareWildcardPattern(File workspaceDir, String pattern, String baseDir) {
        String absolutePattern = UploadSpecHelper.getWildcardAbsolutePattern(workspaceDir, pattern);
        String newPattern = StringUtils.substringAfter((String)UploadSpecHelper.removeParenthesisEscapeChar(UploadSpecHelper.removeParenthesis(absolutePattern)), (String)baseDir);
        newPattern = UploadSpecHelper.removeLeadingSeparator(newPattern);
        if (pattern.endsWith("/")) {
            newPattern = newPattern + "*";
        }
        return newPattern;
    }

    private static String removeLeadingSeparator(String newPattern) {
        if (newPattern.startsWith("/")) {
            newPattern = newPattern.substring(1);
        }
        return newPattern;
    }

    public static String getRelativePath(File base, File file) {
        if (base == null || file == null) {
            return null;
        }
        if (!base.isDirectory() && (base = base.getParentFile()) == null) {
            return null;
        }
        if (base.equals(file)) {
            return ".";
        }
        String filePath = file.getAbsolutePath();
        String basePath = base.getAbsolutePath();
        return UploadSpecHelper.getRelativePath(basePath, filePath, File.separatorChar);
    }

    public static String calculateFileTargetPath(File patternDir, File file, String targetPath) {
        String relativePath = UploadSpecHelper.getRelativePath(patternDir, file);
        relativePath = UploadSpecHelper.stripFileNameFromPath(relativePath);
        if (targetPath.length() == 0) {
            return relativePath;
        }
        if (relativePath.length() == 0) {
            return targetPath;
        }
        return targetPath + '/' + relativePath;
    }

    private static String getRegexpAbsolutePattern(File workspaceDir, String pattern) {
        if (new File(pattern).isAbsolute()) {
            return pattern;
        }
        String escapedWorkspaceDir = PathsUtils.escapeRegexChars(workspaceDir.getAbsolutePath().replace("\\", "/"));
        return escapedWorkspaceDir + "/" + pattern;
    }

    private static String getWildcardAbsolutePattern(File workspaceDir, String pattern) {
        if (new File(pattern).isAbsolute()) {
            return pattern;
        }
        return UploadSpecHelper.escapeParentheses(workspaceDir.getAbsolutePath().replace("\\", "/")) + "/" + pattern;
    }

    private static String getExistingPath(String baseDir) {
        baseDir = PathsUtils.substringBeforeFirstRegex(UploadSpecHelper.removeParenthesis(baseDir));
        while (!new File(baseDir).isDirectory() && baseDir.contains("/")) {
            baseDir = StringUtils.substringBeforeLast((String)baseDir, (String)"/");
        }
        return baseDir;
    }

    private static String removeParenthesisEscapeChar(String baseDir) {
        return baseDir.replace("\\)", ")").replace("\\(", "(");
    }

    private static String removeParenthesis(String baseDir) {
        baseDir = PathsUtils.removeUnescapedChar(baseDir, Character.valueOf("(".charAt(0)));
        baseDir = PathsUtils.removeUnescapedChar(baseDir, Character.valueOf(")".charAt(0)));
        return baseDir;
    }

    private static String escapeParentheses(String path) {
        return path.replace("(", "\\(").replace(")", "\\)");
    }

    private static String cleanRegexpPattern(String absolutePattern, String baseDir) {
        String separator = "/";
        while (baseDir.contains(separator)) {
            baseDir = StringUtils.substringAfter((String)baseDir, (String)separator);
            absolutePattern = StringUtils.substringAfter((String)absolutePattern, (String)separator);
        }
        return UploadSpecHelper.cleanUnopenedParenthesis(absolutePattern);
    }

    private static String getRelativePath(String basePath, String filePath, char separator) {
        int len;
        String filePathToCompare;
        basePath = UploadSpecHelper.ensureEnds(basePath, separator);
        int lastSeparatorIndex = 0;
        String basePathToCompare = basePath.toLowerCase();
        if (basePathToCompare.equals(UploadSpecHelper.ensureEnds(filePathToCompare = filePath.toLowerCase(), separator))) {
            return ".";
        }
        for (len = 0; len < filePath.length() && len < basePath.length() && filePathToCompare.charAt(len) == basePathToCompare.charAt(len); ++len) {
            if (basePath.charAt(len) != separator) continue;
            lastSeparatorIndex = len;
        }
        if (len == 0) {
            return null;
        }
        StringBuilder relativePath = new StringBuilder();
        for (int i = len; i < basePath.length(); ++i) {
            if (basePath.charAt(i) != separator) continue;
            relativePath.append("..");
            relativePath.append(separator);
        }
        relativePath.append(filePath.substring(lastSeparatorIndex + 1));
        return relativePath.toString();
    }

    private static String stripFileNameFromPath(String relativePath) {
        File file = new File(relativePath);
        return file.getPath().substring(0, file.getPath().length() - file.getName().length());
    }

    private static String cleanUnopenedParenthesis(String pattern) {
        int length = pattern.length();
        int numberOfUnclosedParenthesis = 0;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            char c = pattern.charAt(i);
            if (c == ")".charAt(0)) {
                if (numberOfUnclosedParenthesis <= 0) continue;
                --numberOfUnclosedParenthesis;
                stringBuilder.append(c);
                continue;
            }
            stringBuilder.append(c);
            if (c != "(".charAt(0)) continue;
            ++numberOfUnclosedParenthesis;
        }
        return stringBuilder.toString();
    }

    private static String ensureEnds(String s, char endsWith) {
        return StringUtils.endsWith((String)s, (String)"/") ? s : s + endsWith;
    }
}

