/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.clientConfiguration.util.spec;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.jfrog.build.api.Artifact;
import org.jfrog.build.api.Dependency;
import org.jfrog.build.api.builder.ArtifactBuilder;
import org.jfrog.build.api.util.FileChecksumCalculator;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.client.DeployDetails;
import org.jfrog.build.extractor.clientConfiguration.client.ArtifactoryBuildInfoClient;
import org.jfrog.build.extractor.clientConfiguration.client.ArtifactoryDependenciesClient;
import org.jfrog.build.extractor.clientConfiguration.util.DependenciesDownloaderHelper;
import org.jfrog.build.extractor.clientConfiguration.util.spec.FileSpec;
import org.jfrog.build.extractor.clientConfiguration.util.spec.Spec;
import org.jfrog.build.extractor.clientConfiguration.util.spec.UploadSpecHelper;
import org.jfrog.build.extractor.clientConfiguration.util.spec.validator.DownloadSpecValidator;
import org.jfrog.build.extractor.clientConfiguration.util.spec.validator.SpecsValidator;
import org.jfrog.build.extractor.clientConfiguration.util.spec.validator.UploadSpecValidator;

public class SpecsHelper {
    private static final String SHA1 = "SHA1";
    private static final String MD5 = "MD5";
    private final Log log;

    public SpecsHelper(Log log) {
        this.log = log;
    }

    public List<Artifact> uploadArtifactsBySpec(String uploadSpec, File workspace, Multimap<String, String> buildProperties, ArtifactoryBuildInfoClient client) throws IOException, NoSuchAlgorithmException {
        Spec spec = this.getDownloadUploadSpec(uploadSpec, (SpecsValidator)new UploadSpecValidator());
        Set<DeployDetails> artifactsToDeploy = this.getDeployDetails(spec, workspace, buildProperties);
        this.deploy(client, artifactsToDeploy);
        return this.convertDeployDetailsToArtifacts(artifactsToDeploy);
    }

    public List<Artifact> uploadArtifactsBySpec(String uploadSpec, File workspace, Map<String, String> buildProperties, ArtifactoryBuildInfoClient client) throws IOException, NoSuchAlgorithmException {
        return this.uploadArtifactsBySpec(uploadSpec, workspace, SpecsHelper.createMultiMap(buildProperties), client);
    }

    public static <K, V> Multimap<K, V> createMultiMap(Map<K, V> input) {
        ArrayListMultimap multimap = ArrayListMultimap.create();
        for (Map.Entry<K, V> entry : input.entrySet()) {
            multimap.put(entry.getKey(), entry.getValue());
        }
        return multimap;
    }

    public List<Dependency> downloadArtifactsBySpec(String spec, ArtifactoryDependenciesClient client, String targetDirectory) throws IOException {
        DependenciesDownloaderHelper helper = new DependenciesDownloaderHelper(client, targetDirectory, this.log);
        return helper.downloadDependencies(this.getDownloadUploadSpec(spec, (SpecsValidator)new DownloadSpecValidator()));
    }

    private Set<DeployDetails> getDeployDetails(Spec uploadJson, File workspace, Multimap<String, String> buildProperties) throws IOException, NoSuchAlgorithmException {
        this.log.debug("Getting deploy details from spec.");
        HashSet artifactsToDeploy = Sets.newHashSet();
        for (FileSpec uploadFile : uploadJson.getFiles()) {
            this.validateUploadSpec(uploadFile);
            this.log.debug(String.format("Getting deploy details from the following json: \n %s ", uploadFile.toString()));
            Multimap<String, File> targetPathToFilesMap = this.buildTargetPathToFiles(workspace, uploadFile);
            for (Map.Entry entry : targetPathToFilesMap.entries()) {
                artifactsToDeploy.add(this.buildDeployDetailsFromFileEntry(entry, uploadFile, buildProperties));
            }
        }
        return artifactsToDeploy;
    }

    public Spec getDownloadUploadSpec(File downloadUploadSpecFile, SpecsValidator specsValidator) throws IOException {
        return this.getDownloadUploadSpec(FileUtils.readFileToString((File)downloadUploadSpecFile), specsValidator);
    }

    public Spec getDownloadUploadSpec(String downloadUploadSpec, SpecsValidator specsValidator) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        downloadUploadSpec = downloadUploadSpec.replace("\\", "\\\\");
        Spec spec = (Spec)mapper.readValue(downloadUploadSpec, Spec.class);
        specsValidator.validate(spec);
        this.pathToUnixFormat(spec);
        return spec;
    }

    private void pathToUnixFormat(Spec spec) {
        for (FileSpec fileSpec : spec.getFiles()) {
            String separator;
            String string = separator = StringUtils.equalsIgnoreCase((String)fileSpec.getRegexp(), (String)Boolean.TRUE.toString()) ? "\\\\\\\\" : "\\\\";
            if (fileSpec.getTarget() != null) {
                fileSpec.setTarget(fileSpec.getTarget().replaceAll("\\\\", "/"));
            }
            if (fileSpec.getPattern() != null) {
                fileSpec.setPattern(fileSpec.getPattern().replaceAll(separator, "/"));
            }
            if (fileSpec.getExcludePatterns() == null) continue;
            for (int i = 0; i < fileSpec.getExcludePatterns().length; ++i) {
                if (!StringUtils.isNotBlank((String)fileSpec.getExcludePattern(i))) continue;
                fileSpec.setExcludePattern(fileSpec.getExcludePattern(i).replaceAll(separator, "/"), i);
            }
        }
    }

    private DeployDetails buildDeployDetailsFromFileEntry(Map.Entry<String, File> fileEntry, FileSpec uploadFile, Multimap<String, String> buildProperties) throws IOException, NoSuchAlgorithmException {
        Map checksums;
        String targetPath = fileEntry.getKey();
        File artifactFile = fileEntry.getValue();
        String path = UploadSpecHelper.wildcardCalculateTargetPath(targetPath, artifactFile);
        path = StringUtils.replace((String)path, (String)"//", (String)"/");
        try {
            checksums = FileChecksumCalculator.calculateChecksums((File)artifactFile, (String[])new String[]{SHA1, MD5});
        }
        catch (NoSuchAlgorithmException e) {
            throw new NoSuchAlgorithmException(String.format("Could not find checksum algorithm for %s or %s.", SHA1, MD5), e);
        }
        DeployDetails.Builder builder = new DeployDetails.Builder().file(artifactFile).artifactPath(path).targetRepository(this.getRepositoryKey(uploadFile.getTarget())).md5((String)checksums.get(MD5)).sha1((String)checksums.get(SHA1)).explode(BooleanUtils.toBoolean((String)uploadFile.getExplode())).addProperties(this.getPropertiesMap(uploadFile.getProps()));
        if (buildProperties != null && !buildProperties.isEmpty()) {
            builder.addProperties(buildProperties);
        }
        return builder.build();
    }

    private Multimap<String, File> buildTargetPathToFiles(File workspace, FileSpec uploadFile) throws IOException {
        String targetPath;
        String[] excludePatterns;
        boolean isFlat = !"false".equalsIgnoreCase(uploadFile.getFlat());
        boolean isRecursive = !"false".equalsIgnoreCase(uploadFile.getRecursive());
        boolean isRegexp = BooleanUtils.toBoolean((String)uploadFile.getRegexp());
        String pattern = uploadFile.getPattern();
        Multimap<String, File> result = UploadSpecHelper.buildPublishingData(workspace, pattern, excludePatterns = uploadFile.getExcludePatterns(), targetPath = this.getLocalPath(uploadFile.getTarget()), isFlat, isRecursive, isRegexp);
        if (result != null) {
            this.log.info(String.format("For pattern: %s%s %d artifacts were found.", pattern, SpecsHelper.getExcludePatternsLogStr(excludePatterns), result.size()));
        } else {
            this.log.info(String.format("For pattern: %s%s no artifacts were found", pattern, SpecsHelper.getExcludePatternsLogStr(excludePatterns)));
        }
        return result;
    }

    public static String getExcludePatternsLogStr(String[] excludePatterns) {
        return !ArrayUtils.isEmpty((Object[])excludePatterns) ? " with exclude patterns: " + Arrays.toString(excludePatterns) : "";
    }

    private ArrayListMultimap<String, String> getPropertiesMap(String props) {
        ArrayListMultimap propertiesMap = ArrayListMultimap.create();
        SpecsHelper.fillPropertiesMap(props, (ArrayListMultimap<String, String>)propertiesMap);
        return propertiesMap;
    }

    public static void fillPropertiesMap(String props, ArrayListMultimap<String, String> propertiesMap) {
        if (StringUtils.isBlank((String)props)) {
            return;
        }
        for (String prop : props.trim().split(";")) {
            String key = StringUtils.substringBefore((String)prop, (String)"=");
            String[] values = StringUtils.substringAfter((String)prop, (String)"=").split(",");
            propertiesMap.putAll((Object)key, Arrays.asList(values));
        }
    }

    private String getLocalPath(String path) {
        if ("".equals(path = StringUtils.substringAfter((String)path, (String)"/"))) {
            return "/";
        }
        return path;
    }

    private String getRepositoryKey(String path) {
        return StringUtils.substringBefore((String)path, (String)"/");
    }

    private void validateUploadSpec(FileSpec uploadFile) {
        if (StringUtils.isEmpty((String)uploadFile.getTarget())) {
            throw new IllegalArgumentException("The argument 'target' is missing from the upload spec.");
        }
        if (StringUtils.isEmpty((String)uploadFile.getPattern())) {
            throw new IllegalArgumentException("The argument 'pattern' is missing from the upload spec.");
        }
    }

    private List<Artifact> convertDeployDetailsToArtifacts(Set<DeployDetails> details) {
        ArrayList result = Lists.newArrayList();
        for (DeployDetails detail : details) {
            String ext = FilenameUtils.getExtension((String)detail.getFile().getName());
            Artifact artifact = new ArtifactBuilder(detail.getFile().getName()).md5(detail.getMd5()).sha1(detail.getSha1()).type(ext).build();
            result.add(artifact);
        }
        return result;
    }

    private void deploy(ArtifactoryBuildInfoClient client, Set<DeployDetails> artifactsToDeploy) throws IOException {
        for (DeployDetails deployDetail : artifactsToDeploy) {
            client.deployArtifact(deployDetail);
        }
    }
}

