/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.clientConfiguration.util;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.jfrog.build.api.Dependency;
import org.jfrog.build.api.dependency.DownloadableArtifact;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.extractor.clientConfiguration.util.AqlDependenciesHelper;
import org.jfrog.build.extractor.clientConfiguration.util.DependenciesDownloader;
import org.jfrog.build.extractor.clientConfiguration.util.DependenciesHelper;
import org.jfrog.build.extractor.clientConfiguration.util.PathsUtils;

public class WildcardsDependenciesHelper
implements DependenciesHelper {
    private DependenciesDownloader downloader;
    private Log log;
    private String artifactoryUrl;
    private String target;
    private String props;
    private String buildName;
    private String buildNumber;
    private boolean recursive;

    public WildcardsDependenciesHelper(DependenciesDownloader downloader, String target, Log log) {
        this.downloader = downloader;
        this.log = log;
        this.artifactoryUrl = downloader.getClient().getArtifactoryUrl();
        this.target = target;
        this.recursive = false;
        this.props = "";
        this.buildName = "";
        this.buildNumber = "";
    }

    public String getArtifactoryUrl() {
        return this.artifactoryUrl;
    }

    public void setArtifactoryUrl(String artifactoryUrl) {
        this.artifactoryUrl = artifactoryUrl;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public void setProps(String props) {
        this.props = StringUtils.defaultIfEmpty((String)props, (String)"");
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public String getBuildName() {
        return this.buildName;
    }

    public void setBuildName(String buildName) {
        this.buildName = StringUtils.defaultIfEmpty((String)buildName, (String)"");
    }

    public String getBuildNumber() {
        return this.buildNumber;
    }

    public void setBuildNumber(String buildNumber) {
        this.buildNumber = StringUtils.defaultIfEmpty((String)buildNumber, (String)"");
    }

    @Override
    public List<Dependency> retrievePublishedDependencies(String searchPattern, String[] excludePatterns, boolean explode) throws IOException {
        if (StringUtils.isBlank((String)searchPattern)) {
            return Collections.emptyList();
        }
        AqlDependenciesHelper dependenciesHelper = new AqlDependenciesHelper(this.downloader, this.target, this.log);
        if (StringUtils.isNotBlank((String)this.buildName)) {
            dependenciesHelper.setBuildName(this.buildName);
            dependenciesHelper.setBuildNumber(this.buildNumber);
        }
        Set<DownloadableArtifact> downloadableArtifacts = dependenciesHelper.collectArtifactsToDownload(this.buildAqlSearchQuery(searchPattern, excludePatterns, this.recursive, this.props), explode);
        this.replaceTargetPlaceholders(searchPattern, downloadableArtifacts);
        return dependenciesHelper.downloadDependencies(downloadableArtifacts);
    }

    private void replaceTargetPlaceholders(String searchPattern, Set<DownloadableArtifact> downloadableArtifacts) {
        Pattern pattern = Pattern.compile(PathsUtils.pathToRegExp(searchPattern));
        this.target = StringUtils.defaultIfEmpty((String)this.target, (String)"");
        for (DownloadableArtifact artifact : downloadableArtifacts) {
            String repoName = StringUtils.substringAfterLast((String)artifact.getRepoUrl(), (String)"/");
            if (StringUtils.isEmpty((String)this.target) || this.target.endsWith("/")) {
                artifact.setTargetDirPath(PathsUtils.reformatRegexp(repoName + "/" + artifact.getFilePath(), this.target, pattern));
                continue;
            }
            String targetAfterReplacement = PathsUtils.reformatRegexp(repoName + "/" + artifact.getFilePath(), this.target, pattern);
            Map<String, String> targetFileName = PathsUtils.replaceFilesName(targetAfterReplacement, artifact.getRelativeDirPath());
            artifact.setRelativeDirPath(targetFileName.get("srcPath"));
            artifact.setTargetDirPath(targetFileName.get("targetPath"));
        }
    }

    @Override
    public void setFlatDownload(boolean flat) {
        this.downloader.setFlatDownload(flat);
    }

    public String buildAqlSearchQuery(String searchPattern, String[] excludePatterns, boolean recursive, String props) {
        StringBuilder aqlQuery = new StringBuilder();
        searchPattern = this.prepareSearchPattern(searchPattern, true);
        int repoIndex = searchPattern.indexOf("/");
        String repo = searchPattern.substring(0, repoIndex);
        List<PathFilePair> pathFilePairs = this.createPathFilePairs(searchPattern = searchPattern.substring(repoIndex + 1), recursive);
        int pathFilePairsSize = pathFilePairs.size();
        String excludeQuery = this.buildExcludeQuery(excludePatterns, pathFilePairsSize == 0 || recursive);
        String nePath = this.buildNePathQuery(pathFilePairsSize == 0 || !searchPattern.contains("/"));
        aqlQuery.append("{\"repo\": \"").append(repo).append("\",").append(this.buildPropsQuery(props)).append(nePath).append(excludeQuery).append("\"$or\": [");
        if (pathFilePairsSize == 0) {
            aqlQuery.append(this.buildInnerQuery(".", searchPattern));
        } else {
            for (PathFilePair pair : pathFilePairs) {
                aqlQuery.append(this.buildInnerQuery(pair.getPath(), pair.getFile())).append(",");
            }
            aqlQuery.deleteCharAt(aqlQuery.length() - 1);
        }
        return aqlQuery.append("]}").toString();
    }

    private String prepareSearchPattern(String pattern, boolean startsWithRepo) {
        if (startsWithRepo && !pattern.contains("/")) {
            pattern = pattern + "/";
        }
        if (pattern.endsWith("/")) {
            pattern = pattern + "*";
        }
        return pattern.replaceAll("[()]", "");
    }

    private String buildPropsQuery(String props) {
        if (props.equals("")) {
            return "";
        }
        String[] propList = props.split(";");
        StringBuilder query = new StringBuilder();
        for (String prop : propList) {
            String[] keyVal = prop.split("=");
            if (keyVal.length != 2) {
                System.out.print("Invalid props pattern: " + prop);
            }
            String key = keyVal[0];
            String value = keyVal[1];
            query.append("\"@").append(key).append("\": {\"$match\" : \"").append(value).append("\"},");
        }
        return query.toString();
    }

    private String buildExcludeQuery(String[] excludePatterns, boolean useLocalPath) {
        if (excludePatterns == null) {
            return "";
        }
        ArrayList excludePairs = Lists.newArrayList();
        for (String excludePattern : excludePatterns) {
            excludePairs.addAll(this.createPathFilePairs(this.prepareSearchPattern(excludePattern, false), this.recursive));
        }
        StringBuilder excludeQuery = new StringBuilder();
        for (PathFilePair singleExcludePattern : excludePairs) {
            String excludePath = singleExcludePattern.getPath();
            if (!useLocalPath && ".".equals(excludePath)) {
                excludePath = "*";
            }
            excludeQuery.append(String.format("\"$or\": [{\"path\": {\"$nmatch\": \"%s\"}, \"name\": {\"$nmatch\": \"%s\"}}],", excludePath, singleExcludePattern.getFile()));
        }
        return excludeQuery.toString();
    }

    private String buildNePathQuery(boolean includeRoot) {
        return includeRoot ? "" : "\"path\": {\"$ne\": \".\"}, ";
    }

    private String buildInnerQuery(String path, String name) {
        return String.format("{\"$and\": [{\"path\": { \"$match\": \"%s\"},\"name\": { \"$match\": \"%s\"}}]}", path, name);
    }

    private List<PathFilePair> createPathFilePairs(String pattern, boolean recursive) {
        String name;
        String path;
        String defaultPath = recursive ? "*" : ".";
        ArrayList<PathFilePair> pairs = new ArrayList<PathFilePair>();
        if (pattern.equals("*")) {
            pairs.add(new PathFilePair(defaultPath, "*"));
            return pairs;
        }
        int slashIndex = pattern.lastIndexOf("/");
        if (slashIndex < 0) {
            pairs.add(new PathFilePair(".", pattern));
            path = "";
            name = pattern;
        } else {
            path = pattern.substring(0, slashIndex);
            name = pattern.substring(slashIndex + 1);
            pairs.add(new PathFilePair(path, name));
        }
        if (!recursive) {
            return pairs;
        }
        if (name.equals("*")) {
            path = path + "/*";
            pairs.add(new PathFilePair(path, "*"));
            return pairs;
        }
        pattern = name;
        String[] sections = pattern.split("\\*", -1);
        int size = sections.length;
        for (int i = 0; i < size; ++i) {
            ArrayList<String> options = new ArrayList<String>();
            if (i + 1 < size) {
                options.add(sections[i] + "*/");
            }
            for (String option : options) {
                String str = "";
                for (int j = 0; j < size; ++j) {
                    if (j > 0) {
                        str = str + "*";
                    }
                    str = j == i ? str + option : str + sections[j];
                }
                String[] split = str.split("/", -1);
                String filePath = split[0];
                String fileName = split[1];
                if (fileName.equals("")) {
                    fileName = "*";
                }
                if (!path.equals("") && !path.endsWith("/")) {
                    path = path + "/";
                }
                pairs.add(new PathFilePair(path + filePath, fileName));
            }
        }
        return pairs;
    }

    private class PathFilePair {
        private String path;
        private String file;

        public PathFilePair(String path, String file) {
            this.path = path;
            this.file = file;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public String getFile() {
            return this.file;
        }

        public void setFile(String file) {
            this.file = file;
        }
    }
}

