/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.clientConfiguration.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.jfrog.build.api.dependency.pattern.BuildDependencyPattern;
import org.jfrog.build.api.dependency.pattern.DependencyPattern;
import org.jfrog.build.api.dependency.pattern.PatternType;

public class PatternFactory {
    public static DependencyPattern create(String patternLine) {
        boolean lineIsBuildDependency;
        String[] splitPattern = patternLine.split("=>|=!>");
        String sourcePattern = "";
        String targetPattern = "";
        if (splitPattern.length > 0) {
            sourcePattern = FilenameUtils.separatorsToUnix((String)splitPattern[0].trim());
        }
        if (splitPattern.length > 1) {
            targetPattern = FilenameUtils.separatorsToUnix((String)splitPattern[1].trim());
        }
        String pattern = PatternFactory.extractPatternFromSource(sourcePattern);
        String matrixParams = PatternFactory.extractMatrixParamsFromSource(sourcePattern);
        int index1 = sourcePattern.lastIndexOf(64);
        int index2 = sourcePattern.lastIndexOf(35);
        boolean bl = lineIsBuildDependency = index1 > 0 && index2 > index1 && index2 < sourcePattern.length() - 1;
        if (lineIsBuildDependency) {
            String buildDependencyPattern = StringUtils.substring((String)sourcePattern, (int)0, (int)index1);
            String buildName = StringUtils.substring((String)sourcePattern, (int)(index1 + 1), (int)index2);
            String buildNumber = StringUtils.substring((String)sourcePattern, (int)(index2 + 1));
            if (StringUtils.isNotBlank((String)buildName) || StringUtils.isNotBlank((String)buildNumber) || StringUtils.isNotBlank((String)buildDependencyPattern)) {
                matrixParams = StringUtils.substring((String)buildDependencyPattern, (int)(pattern.length() + 1), (int)index1);
                if (StringUtils.isNotBlank((String)matrixParams)) {
                    buildDependencyPattern = StringUtils.substring((String)buildDependencyPattern, (int)0, (int)(index1 - matrixParams.length() - 1));
                }
                return new BuildDependencyPattern(buildDependencyPattern, matrixParams, targetPattern, PatternFactory.getPatternType(patternLine), buildName, buildNumber);
            }
        } else {
            return new DependencyPattern(pattern, matrixParams, targetPattern, PatternFactory.getPatternType(patternLine));
        }
        return null;
    }

    private static PatternType getPatternType(String linePattern) {
        if (StringUtils.contains((String)linePattern, (String)"=!>")) {
            return PatternType.DELETE;
        }
        return PatternType.NORMAL;
    }

    private static String extractPatternFromSource(String sourcePattern) {
        int indexOfSemiColon = sourcePattern.indexOf(59);
        if (indexOfSemiColon == -1) {
            return sourcePattern;
        }
        return StringUtils.substring((String)sourcePattern, (int)0, (int)indexOfSemiColon);
    }

    private static String extractMatrixParamsFromSource(String sourcePattern) {
        StringBuilder matrixParamBuilder = new StringBuilder();
        String[] patternFragments = StringUtils.split((String)sourcePattern, (char)';');
        if (patternFragments.length > 1) {
            for (int i = 1; i < patternFragments.length; ++i) {
                String matrixParam = patternFragments[i];
                String[] matrixParamFragments = StringUtils.split((String)matrixParam, (char)'=');
                if (matrixParamFragments.length == 0) continue;
                String key = matrixParamFragments[0];
                boolean mandatory = false;
                if (key.endsWith("+")) {
                    mandatory = true;
                    key = StringUtils.substring((String)key, (int)0, (int)(key.length() - 1));
                }
                if (i > 1) {
                    matrixParamBuilder.append(";");
                }
                try {
                    matrixParamBuilder.append(URLEncoder.encode(key, "utf-8"));
                    if (mandatory) {
                        matrixParamBuilder.append("+");
                    }
                    if (matrixParamFragments.length <= 1) continue;
                    matrixParamBuilder.append("=").append(URLEncoder.encode(matrixParamFragments[1], "utf-8"));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new IllegalArgumentException(e.getMessage());
                }
            }
        }
        return matrixParamBuilder.toString();
    }
}

