/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.clientConfiguration.util;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jfrog.build.api.Dependency;
import org.jfrog.build.api.dependency.DownloadableArtifact;
import org.jfrog.build.api.util.FileChecksumCalculator;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.extractor.clientConfiguration.client.ArtifactoryDependenciesClient;
import org.jfrog.build.extractor.clientConfiguration.util.DependenciesDownloader;
import org.jfrog.build.extractor.clientConfiguration.util.DependenciesDownloaderHelper;

public class DependenciesDownloaderImpl
implements DependenciesDownloader {
    private ArtifactoryDependenciesClient client;
    private File workingDirectory;
    private Log log;
    private boolean flatDownload = false;

    public DependenciesDownloaderImpl(ArtifactoryDependenciesClient client, String workingDirectory, Log log) {
        this.workingDirectory = new File(workingDirectory);
        this.log = log;
        this.flatDownload = false;
        this.client = client;
    }

    @Override
    public ArtifactoryDependenciesClient getClient() {
        return this.client;
    }

    @Override
    public List<Dependency> download(Set<DownloadableArtifact> downloadableArtifacts) throws IOException {
        DependenciesDownloaderHelper helper = new DependenciesDownloaderHelper(this, this.log);
        return helper.downloadDependencies(downloadableArtifacts);
    }

    @Override
    public String getTargetDir(String targetDir, String relativeDir) throws IOException {
        String downloadFileRelativePath = this.flatDownload && relativeDir.contains("/") ? StringUtils.substringAfterLast((String)relativeDir, (String)"/") : relativeDir;
        return FilenameUtils.concat((String)this.workingDirectory.getPath(), (String)FilenameUtils.concat((String)targetDir, (String)downloadFileRelativePath));
    }

    @Override
    public Map<String, String> saveDownloadedFile(InputStream is, String filePath) throws IOException {
        File dest = new File(filePath);
        if (dest.exists()) {
            dest.delete();
        } else {
            dest.getParentFile().mkdirs();
        }
        FileOutputStream fileOutputStream = null;
        try {
            dest.createNewFile();
            fileOutputStream = new FileOutputStream(dest);
            IOUtils.copyLarge((InputStream)is, (OutputStream)fileOutputStream);
        }
        catch (IOException e) {
            try {
                throw new IOException("Could not create or write to file: " + dest.getCanonicalPath() + ". " + e.getMessage());
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly((InputStream)is);
                IOUtils.closeQuietly(fileOutputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)is);
        IOUtils.closeQuietly((OutputStream)fileOutputStream);
        try {
            return FileChecksumCalculator.calculateChecksums((File)dest, (String[])new String[]{"md5", "sha1"});
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Could not find checksum algorithm: " + e.getLocalizedMessage());
        }
    }

    @Override
    public boolean isFileExistsLocally(String filePath, String md5, String sha1) throws IOException {
        File dest = new File(filePath);
        if (!dest.exists()) {
            return false;
        }
        if (dest.isDirectory()) {
            throw new IOException(String.format("File can't override an existing directory: %s", dest.toString()));
        }
        try {
            boolean isExists;
            Map checksumsMap = FileChecksumCalculator.calculateChecksums((File)dest, (String[])new String[]{"md5", "sha1"});
            boolean bl = isExists = checksumsMap != null && StringUtils.isNotBlank((String)md5) && StringUtils.equals((String)md5, (String)((String)checksumsMap.get("md5"))) && StringUtils.isNotBlank((String)sha1) && StringUtils.equals((String)sha1, (String)((String)checksumsMap.get("sha1")));
            if (isExists) {
                return true;
            }
            this.log.info(String.format("Overriding existing in destination file: %s", dest.toString()));
            return false;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Could not find checksum algorithm: " + e.getLocalizedMessage());
        }
    }

    @Override
    public void removeUnusedArtifactsFromLocal(Set<String> allResolvesFiles, Set<String> forDeletionFiles) throws IOException {
        for (String resolvedFile : forDeletionFiles) {
            File resolvedFileParent = FileUtils.getFile((String[])new String[]{resolvedFile}).getParentFile();
            File[] fileSiblings = resolvedFileParent.listFiles();
            if (fileSiblings == null || fileSiblings.length == 0) continue;
            for (File sibling : fileSiblings) {
                if (this.isResolvedOrParentOfResolvedFile(allResolvesFiles, sibling.getPath())) continue;
                this.log.info("Deleted unresolved file '" + sibling.getPath() + "'");
                sibling.delete();
            }
        }
    }

    @Override
    public void setFlatDownload(boolean flat) {
        this.flatDownload = flat;
    }

    private boolean isResolvedOrParentOfResolvedFile(Set<String> resolvedFiles, final String path) {
        return Iterables.any(resolvedFiles, (Predicate)new Predicate<String>(){

            public boolean apply(String filePath) {
                return StringUtils.equals((String)filePath, (String)path) || StringUtils.startsWith((String)filePath, (String)path);
            }
        });
    }
}

