/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.clientConfiguration.util;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.jfrog.build.api.Dependency;
import org.jfrog.build.api.dependency.DownloadableArtifact;
import org.jfrog.build.api.dependency.pattern.PatternType;
import org.jfrog.build.api.search.AqlSearchResult;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.extractor.clientConfiguration.util.DependenciesDownloader;
import org.jfrog.build.extractor.clientConfiguration.util.DependenciesHelper;

public class AqlDependenciesHelper
implements DependenciesHelper {
    private DependenciesDownloader downloader;
    private Log log;
    private String artifactoryUrl;
    private String target;
    private String buildName;
    private String buildNumber;

    public AqlDependenciesHelper(DependenciesDownloader downloader, String target, Log log) {
        this.downloader = downloader;
        this.log = log;
        this.artifactoryUrl = downloader.getClient().getArtifactoryUrl();
        this.target = target;
    }

    @Override
    public List<Dependency> retrievePublishedDependencies(String aql, String[] excludePattern, boolean explode) throws IOException {
        if (StringUtils.isBlank((String)aql)) {
            return Collections.emptyList();
        }
        Set<DownloadableArtifact> downloadableArtifacts = this.collectArtifactsToDownload(aql, explode);
        return this.downloadDependencies(downloadableArtifacts);
    }

    public List<Dependency> downloadDependencies(Set<DownloadableArtifact> downloadableArtifacts) throws IOException {
        this.log.info("Beginning to resolve Build Info published dependencies.");
        List<Dependency> dependencies = this.downloader.download(downloadableArtifacts);
        this.log.info("Finished resolving Build Info published dependencies.");
        return dependencies;
    }

    @Override
    public void setFlatDownload(boolean flat) {
        this.downloader.setFlatDownload(flat);
    }

    public Set<DownloadableArtifact> collectArtifactsToDownload(String aql, boolean explode) throws IOException {
        HashSet downloadableArtifacts = Sets.newHashSet();
        if (StringUtils.isNotBlank((String)this.buildName)) {
            aql = this.addBuildToQuery(aql);
        }
        aql = "items.find(" + aql + ")";
        AqlSearchResult aqlSearchResult = this.downloader.getClient().searchArtifactsByAql(aql);
        List searchResults = aqlSearchResult.getResults();
        for (AqlSearchResult.SearchEntry searchEntry : searchResults) {
            String path = searchEntry.getPath().equals(".") ? "" : searchEntry.getPath() + "/";
            DownloadableArtifact downloadableArtifact = new DownloadableArtifact(StringUtils.stripEnd((String)this.artifactoryUrl, (String)"/") + "/" + searchEntry.getRepo(), this.target, path + searchEntry.getName(), "", "", PatternType.NORMAL);
            downloadableArtifact.setExplode(explode);
            downloadableArtifacts.add(downloadableArtifact);
        }
        return downloadableArtifacts;
    }

    private String addBuildToQuery(String aql) {
        return "{\"$and\": [" + aql + "," + "{" + "\"artifact.module.build.name\": {" + "\"$eq\": \"" + this.buildName + "\"" + "}" + "}," + "{" + "\"artifact.module.build.number\": {" + "\"$eq\": \"" + this.buildNumber + "\"" + "}" + "}" + "]" + "}";
    }

    public void setArtifactoryUrl(String artifactoryUrl) {
        this.artifactoryUrl = artifactoryUrl;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public String getArtifactoryUrl() {
        return this.artifactoryUrl;
    }

    public String getBuildName() {
        return this.buildName;
    }

    public void setBuildName(String buildName) {
        this.buildName = buildName;
    }

    public String getBuildNumber() {
        return this.buildNumber;
    }

    public void setBuildNumber(String buildNumber) {
        this.buildNumber = buildNumber;
    }
}

