/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.clientConfiguration.client;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.client.PreemptiveHttpClient;
import org.jfrog.build.client.artifactoryXrayResponse.ArtifactoryXrayResponse;
import org.jfrog.build.extractor.clientConfiguration.client.ArtifactoryBaseClient;

public class ArtifactoryXrayClient
extends ArtifactoryBaseClient {
    private static final String SCAN_BUILD_URL = "/api/xray/scanBuild";
    private static final int XRAY_SCAN_RETRY_CONSECUTIVE_RETRIES = 10;
    private static final int XRAY_SCAN_CONNECTION_TIMEOUT_SECS = 90;
    private static final int XRAY_SCAN_SLEEP_BETWEEN_RETRIES_MILLIS = 15000;
    private static final String XRAY_FATAL_FAIL_STATUS = "-1";

    public ArtifactoryXrayClient(String artifactoryUrl, String username, String password, Log logger) {
        super(artifactoryUrl, username, password, logger);
    }

    public ArtifactoryXrayResponse xrayScanBuild(String buildName, String buildNumber, String context) throws IOException, InterruptedException {
        StringEntity entity = new StringEntity("{\"buildName\":\"" + buildName + "\",\"buildNumber\":\"" + buildNumber + "\",\"context\":\"" + context + "\"}");
        entity.setContentType("application/json");
        String scanUrl = this.artifactoryUrl + SCAN_BUILD_URL;
        HttpPost httpPost = new HttpPost(scanUrl);
        httpPost.setEntity((HttpEntity)entity);
        return this.execute((HttpRequestBase)httpPost);
    }

    private boolean isStableConnection(long lastConnectionAttemptMillis) {
        long stableConnectionMillis = 100000L;
        return lastConnectionAttemptMillis + 100000L < System.currentTimeMillis();
    }

    private ArtifactoryXrayResponse parseXrayScanResponse(HttpResponse response) throws IOException {
        if (response.getStatusLine().getStatusCode() != 200) {
            throw new IOException("Artifactory response: " + response.getStatusLine().getReasonPhrase());
        }
        ObjectMapper mapper = new ObjectMapper();
        JsonNode result = mapper.readTree(response.getEntity().getContent());
        if (result.get("errors") != null) {
            String resultStr = result.get("errors").toString();
            for (JsonNode error : result.get("errors")) {
                if (!error.get("status").toString().equals(XRAY_FATAL_FAIL_STATUS)) continue;
                throw new RuntimeException("Artifactory response: " + resultStr);
            }
            throw new IOException("Artifactory response: " + resultStr);
        }
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return (ArtifactoryXrayResponse)mapper.treeToValue((TreeNode)result, ArtifactoryXrayResponse.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArtifactoryXrayResponse execute(HttpRequestBase httpRequest) throws InterruptedException, IOException {
        PreemptiveHttpClient client = this.httpClient.getHttpClient(90);
        int retryNum = 0;
        long lastConnectionAttemptMillis = 0L;
        HttpResponse response = null;
        while (true) {
            try {
                lastConnectionAttemptMillis = System.currentTimeMillis();
                ++retryNum;
                response = client.execute((HttpUriRequest)httpRequest);
                ArtifactoryXrayResponse artifactoryXrayResponse = this.parseXrayScanResponse(response);
                return artifactoryXrayResponse;
            }
            catch (IOException e) {
                if (this.isStableConnection(lastConnectionAttemptMillis)) {
                    retryNum = 0;
                    continue;
                }
                if (10 <= retryNum) {
                    throw e;
                }
                this.log.warn("Xray scan connection lost: " + e.getMessage() + ", attempting to reconnect...");
                Thread.sleep(15000L);
                continue;
            }
            finally {
                if (response != null) {
                    try {
                        EntityUtils.consume((HttpEntity)response.getEntity());
                    }
                    catch (IOException iOException) {}
                }
                httpRequest.releaseConnection();
                continue;
            }
            break;
        }
    }
}

