/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.clientConfiguration.util.spec;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.jfrog.build.api.util.FileChecksumCalculator;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.client.DeployDetails;
import org.jfrog.build.extractor.clientConfiguration.util.PublishedItemsHelper;
import org.jfrog.build.extractor.clientConfiguration.util.spec.FileSpec;
import org.jfrog.build.extractor.clientConfiguration.util.spec.Spec;

public class SpecsHelper {
    private static final String SHA1 = "SHA1";
    private static final String MD5 = "MD5";
    private final Log log;

    public SpecsHelper(Log log) {
        this.log = log;
    }

    public Set<DeployDetails> getDeployDetails(Spec uploadJson, File workspace) throws IOException, NoSuchAlgorithmException {
        return this.getDeployDetails(uploadJson, workspace, null);
    }

    public Set<DeployDetails> getDeployDetails(Spec uploadJson, File workspace, ArrayListMultimap<String, String> buildProperties) throws IOException, NoSuchAlgorithmException {
        this.log.debug("Getting deploy details from spec.");
        HashSet artifactsToDeploy = Sets.newHashSet();
        for (FileSpec uploadFile : uploadJson.getFiles()) {
            this.validateUploadSpec(uploadFile);
            this.log.debug(String.format("Getting deploy details from the following json: \n %s ", uploadFile.toString()));
            Multimap<String, File> targetPathToFilesMap = this.buildTargetPathToFiles(workspace, uploadFile);
            for (Map.Entry entry : targetPathToFilesMap.entries()) {
                artifactsToDeploy.addAll(this.buildDeployDetailsFromFileEntry(entry, uploadFile, buildProperties));
            }
        }
        return artifactsToDeploy;
    }

    public Spec getDownloadUploadSpec(File downloadUploadSpecFile) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        String downloadUploadSpec = FileUtils.readFileToString((File)downloadUploadSpecFile);
        downloadUploadSpec = downloadUploadSpec.replace("\\", "\\\\");
        Spec spec = (Spec)mapper.readValue(downloadUploadSpec, Spec.class);
        this.pathToUnixFormat(spec);
        return spec;
    }

    public Spec getDownloadUploadSpec(String downloadUploadSpec) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        downloadUploadSpec = downloadUploadSpec.replace("\\", "\\\\");
        Spec spec = (Spec)mapper.readValue(downloadUploadSpec, Spec.class);
        this.pathToUnixFormat(spec);
        return spec;
    }

    private void pathToUnixFormat(Spec spec) {
        for (FileSpec fileSpec : spec.getFiles()) {
            if (fileSpec.getTarget() != null) {
                fileSpec.setTarget(fileSpec.getTarget().replaceAll("\\\\", "/"));
            }
            if (fileSpec.getPattern() == null) continue;
            if (!StringUtils.equalsIgnoreCase((String)fileSpec.getRegexp(), (String)Boolean.TRUE.toString())) {
                fileSpec.setPattern(fileSpec.getPattern().replaceAll("\\\\", "/"));
                continue;
            }
            fileSpec.setPattern(fileSpec.getPattern().replaceAll("\\\\\\\\", "/"));
        }
    }

    private Set<DeployDetails> buildDeployDetailsFromFileEntry(Map.Entry<String, File> fileEntry, FileSpec uploadFile, ArrayListMultimap<String, String> buildProperties) throws IOException, NoSuchAlgorithmException {
        Map checksums;
        HashSet result = Sets.newHashSet();
        String targetPath = fileEntry.getKey();
        File artifactFile = fileEntry.getValue();
        String path = PublishedItemsHelper.wildcardCalculateTargetPath(targetPath, artifactFile);
        path = StringUtils.replace((String)path, (String)"//", (String)"/");
        try {
            checksums = FileChecksumCalculator.calculateChecksums((File)artifactFile, (String[])new String[]{SHA1, MD5});
        }
        catch (NoSuchAlgorithmException e) {
            throw new NoSuchAlgorithmException(String.format("Could not find checksum algorithm for %s or %s.", SHA1, MD5), e);
        }
        DeployDetails.Builder builder = new DeployDetails.Builder().file(artifactFile).artifactPath(path).targetRepository(this.getRepositoryKey(uploadFile.getTarget())).md5((String)checksums.get(MD5)).sha1((String)checksums.get(SHA1)).addProperties(this.getPropertiesMap(uploadFile.getProps()));
        if (buildProperties != null && !buildProperties.isEmpty()) {
            builder.addProperties(buildProperties);
        }
        result.add(builder.build());
        return result;
    }

    private Multimap<String, File> buildTargetPathToFiles(File workspace, FileSpec uploadFile) throws IOException {
        String targetPath;
        boolean isFlat = !"false".equalsIgnoreCase(uploadFile.getFlat());
        boolean isRecursive = !"false".equalsIgnoreCase(uploadFile.getRecursive());
        boolean isRegexp = BooleanUtils.toBoolean((String)uploadFile.getRegexp());
        String pattern = uploadFile.getPattern();
        Multimap<String, File> result = PublishedItemsHelper.buildPublishingData(workspace, pattern, targetPath = this.getLocalPath(uploadFile.getTarget()), isFlat, isRecursive, isRegexp);
        if (result != null) {
            this.log.info(String.format("For pattern: %s %d artifacts were found.", pattern, result.size()));
        } else {
            this.log.info(String.format("For pattern: %s no artifacts were found", pattern));
        }
        return result;
    }

    private ArrayListMultimap<String, String> getPropertiesMap(String props) {
        ArrayListMultimap properties = ArrayListMultimap.create();
        if (props == null) {
            return properties;
        }
        for (String prop : props.trim().split(";")) {
            String key = StringUtils.substringBefore((String)prop, (String)"=");
            String values = StringUtils.substringAfter((String)prop, (String)"=");
            for (String value : values.split(",")) {
                properties.put((Object)key, (Object)value);
            }
        }
        return properties;
    }

    private String getLocalPath(String path) {
        return StringUtils.substringAfter((String)path, (String)"/");
    }

    private String getRepositoryKey(String path) {
        return StringUtils.substringBefore((String)path, (String)"/");
    }

    private void validateUploadSpec(FileSpec uploadFile) {
        if (StringUtils.isEmpty((String)uploadFile.getTarget())) {
            throw new IllegalArgumentException("The argument 'target' is missing from the upload spec.");
        }
        if (StringUtils.isEmpty((String)uploadFile.getPattern())) {
            throw new IllegalArgumentException("The argument 'pattern' is missing from the upload spec.");
        }
    }
}

