/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.clientConfiguration.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.jfrog.build.api.Dependency;
import org.jfrog.build.api.dependency.DownloadableArtifact;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.extractor.clientConfiguration.util.AqlDependenciesHelper;
import org.jfrog.build.extractor.clientConfiguration.util.DependenciesDownloader;
import org.jfrog.build.extractor.clientConfiguration.util.DependenciesHelper;
import org.jfrog.build.extractor.clientConfiguration.util.PathsUtils;

public class WildcardsDependenciesHelper
implements DependenciesHelper {
    private DependenciesDownloader downloader;
    private Log log;
    private String artifactoryUrl;
    private String target;
    private String props;
    private String buildName;
    private String buildNumber;
    private boolean recursive;

    public WildcardsDependenciesHelper(DependenciesDownloader downloader, String artifactoryUrl, String target, Log log) {
        this.downloader = downloader;
        this.log = log;
        this.artifactoryUrl = artifactoryUrl;
        this.target = target;
        this.recursive = false;
        this.props = "";
        this.buildName = "";
        this.buildNumber = "";
    }

    public String getArtifactoryUrl() {
        return this.artifactoryUrl;
    }

    public void setArtifactoryUrl(String artifactoryUrl) {
        this.artifactoryUrl = artifactoryUrl;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public void setProps(String props) {
        this.props = StringUtils.defaultIfEmpty((String)props, (String)"");
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public String getBuildName() {
        return this.buildName;
    }

    public void setBuildName(String buildName) {
        this.buildName = StringUtils.defaultIfEmpty((String)buildName, (String)"");
    }

    public String getBuildNumber() {
        return this.buildNumber;
    }

    public void setBuildNumber(String buildNumber) {
        this.buildNumber = StringUtils.defaultIfEmpty((String)buildNumber, (String)"");
    }

    @Override
    public List<Dependency> retrievePublishedDependencies(String searchPattern) throws IOException {
        if (StringUtils.isBlank((String)searchPattern)) {
            return Collections.emptyList();
        }
        AqlDependenciesHelper dependenciesHelper = new AqlDependenciesHelper(this.downloader, this.artifactoryUrl, this.target, this.log);
        if (StringUtils.isNotBlank((String)this.buildName)) {
            dependenciesHelper.setBuildName(this.buildName);
            dependenciesHelper.setBuildNumber(this.buildNumber);
        }
        Set<DownloadableArtifact> downloadableArtifacts = dependenciesHelper.collectArtifactsToDownload(this.buildAqlSearchQuery(searchPattern, this.recursive, this.props));
        this.replaceTargetPlaceholders(searchPattern, downloadableArtifacts);
        return dependenciesHelper.downloadDependencies(downloadableArtifacts);
    }

    private void replaceTargetPlaceholders(String searchPattern, Set<DownloadableArtifact> downloadableArtifacts) {
        Pattern pattern = Pattern.compile(PathsUtils.pathToRegExp(searchPattern));
        this.target = StringUtils.defaultIfEmpty((String)this.target, (String)"");
        for (DownloadableArtifact artifact : downloadableArtifacts) {
            String repoName = StringUtils.substringAfterLast((String)artifact.getRepoUrl(), (String)"/");
            if (StringUtils.isEmpty((String)this.target) || this.target.endsWith("/")) {
                artifact.setTargetDirPath(PathsUtils.reformatRegexp(repoName + "/" + artifact.getFilePath(), this.target, pattern));
                continue;
            }
            String targetAfterReplacement = PathsUtils.reformatRegexp(repoName + "/" + artifact.getFilePath(), this.target, pattern);
            Map<String, String> targetFileName = PathsUtils.replaceFilesName(targetAfterReplacement, artifact.getRelativeDirPath());
            artifact.setRelativeDirPath(targetFileName.get("srcPath"));
            artifact.setTargetDirPath(targetFileName.get("targetPath"));
        }
    }

    @Override
    public void setFlatDownload(boolean flat) {
        this.downloader.setFlatDownload(flat);
    }

    public String buildAqlSearchQuery(String searchPattern, boolean recursive, String props) {
        searchPattern = this.prepareSearchPattern(searchPattern);
        int index = searchPattern.indexOf("/");
        String repo = searchPattern.substring(0, index);
        searchPattern = searchPattern.substring(index + 1);
        List<PathFilePair> pairs = this.createPathFilePairs(searchPattern, recursive);
        int size = pairs.size();
        String json = "{\"repo\": \"" + repo + "\"," + this.buildPropsQuery(props) + "\"$or\": [";
        if (size == 0) {
            json = json + "{" + this.buildInnerQuery(".", searchPattern) + "}";
        } else {
            for (int i = 0; i < size; ++i) {
                json = json + "{" + this.buildInnerQuery(pairs.get(i).getPath(), pairs.get(i).getFile()) + "}";
                if (i + 1 >= size) continue;
                json = json + ",";
            }
        }
        return json + "]" + "}";
    }

    private String prepareSearchPattern(String pattern) {
        int index = pattern.indexOf("/");
        if (index < 0) {
            pattern = pattern + "/";
        }
        if (pattern.endsWith("/")) {
            pattern = pattern + "*";
        }
        return pattern.replaceAll("[()]", "");
    }

    private String buildPropsQuery(String props) {
        if (props.equals("")) {
            return "";
        }
        String[] propList = props.split(";");
        String query = "";
        for (int i = 0; i < propList.length; ++i) {
            String[] keyVal = propList[i].split("=");
            if (keyVal.length != 2) {
                System.out.print("Invalid props pattern: " + propList[i]);
            }
            String key = keyVal[0];
            String value = keyVal[1];
            query = query + "\"@" + key + "\": {\"$match\" : \"" + value + "\"},";
        }
        return query;
    }

    private String buildInnerQuery(String path, String name) {
        return "\"$and\": [{\"path\": {\"$match\":\"" + path + "\"" + "}," + "\"name\":{" + "\"$match\":" + "\"" + name + "\"" + "}" + "}]";
    }

    private List<PathFilePair> createPathFilePairs(String pattern, boolean recursive) {
        String defaultPath = recursive ? "*" : ".";
        ArrayList<PathFilePair> pairs = new ArrayList<PathFilePair>();
        if (pattern.equals("*")) {
            pairs.add(new PathFilePair(defaultPath, "*"));
            return pairs;
        }
        int slashIndex = pattern.lastIndexOf("/");
        String path = "";
        String name = "";
        if (slashIndex < 0) {
            pairs.add(new PathFilePair(".", pattern));
            path = "";
            name = pattern;
        } else if (slashIndex >= 0) {
            path = pattern.substring(0, slashIndex);
            name = pattern.substring(slashIndex + 1);
            pairs.add(new PathFilePair(path, name));
        }
        if (!recursive) {
            return pairs;
        }
        if (name.equals("*")) {
            path = path + "/*";
            pairs.add(new PathFilePair(path, "*"));
            return pairs;
        }
        pattern = name;
        String[] sections = pattern.split("\\*");
        int size = sections.length;
        for (int i = 0; i < size; ++i) {
            ArrayList<String> options = new ArrayList<String>();
            if (i + 1 < size) {
                options.add(sections[i] + "*/");
            }
            for (String option : options) {
                String str = "";
                for (int j = 0; j < size; ++j) {
                    if (j > 0) {
                        str = str + "*";
                    }
                    str = j == i ? str + option : str + sections[j];
                }
                String[] split = str.split("/");
                String filePath = split[0];
                String fileName = split[1];
                if (fileName.equals("")) {
                    fileName = "*";
                }
                if (!path.equals("")) {
                    path = path + "/";
                }
                pairs.add(new PathFilePair(path + filePath, fileName));
            }
        }
        return pairs;
    }

    private class PathFilePair {
        private String path;
        private String file;

        public PathFilePair(String path, String file) {
            this.path = path;
            this.file = file;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public String getFile() {
            return this.file;
        }

        public void setFile(String file) {
            this.file = file;
        }
    }
}

