/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.clientConfiguration.client;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.jfrog.build.api.dependency.BuildPatternArtifacts;
import org.jfrog.build.api.dependency.BuildPatternArtifactsRequest;
import org.jfrog.build.api.dependency.PatternResultFileSet;
import org.jfrog.build.api.dependency.PropertySearchResult;
import org.jfrog.build.api.search.AqlSearchResult;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.client.ArtifactoryHttpClient;
import org.jfrog.build.client.PreemptiveHttpClient;
import org.jfrog.build.extractor.clientConfiguration.client.ArtifactoryBaseClient;
import org.jfrog.build.extractor.clientConfiguration.util.JsonSerializer;

public class ArtifactoryDependenciesClient
extends ArtifactoryBaseClient {
    public ArtifactoryDependenciesClient(String artifactoryUrl, String username, String password, Log logger) {
        super(artifactoryUrl, username, password, logger);
    }

    public List<BuildPatternArtifacts> retrievePatternArtifacts(List<BuildPatternArtifactsRequest> requests) throws IOException {
        String json = new JsonSerializer<List<BuildPatternArtifactsRequest>>().toJSON(requests);
        HttpPost post = new HttpPost(this.artifactoryUrl + "/api/build/patternArtifacts");
        StringEntity stringEntity = new StringEntity(json);
        stringEntity.setContentType("application/vnd.org.jfrog.artifactory+json");
        post.setEntity((HttpEntity)stringEntity);
        List<BuildPatternArtifacts> artifacts = this.readResponse(this.httpClient.getHttpClient().execute((HttpUriRequest)post), new TypeReference<List<BuildPatternArtifacts>>(){}, "Failed to retrieve build artifacts report", false);
        return artifacts;
    }

    public PatternResultFileSet searchArtifactsByPattern(String pattern) throws IOException {
        PreemptiveHttpClient client = this.httpClient.getHttpClient();
        String url = this.artifactoryUrl + "/api/search/pattern?pattern=" + pattern;
        PatternResultFileSet result = this.readResponse(client.execute((HttpUriRequest)new HttpGet(url)), new TypeReference<PatternResultFileSet>(){}, "Failed to search artifact by the pattern '" + pattern + "'", false);
        return result;
    }

    public PropertySearchResult searchArtifactsByProperties(String properties) throws IOException {
        PreemptiveHttpClient client = this.httpClient.getHttpClient();
        String replacedProperties = StringUtils.replaceEach((String)properties, (String[])new String[]{";", "+"}, (String[])new String[]{"&", ""});
        String url = this.artifactoryUrl + "/api/search/prop?" + replacedProperties;
        PropertySearchResult result = this.readResponse(client.execute((HttpUriRequest)new HttpGet(url)), new TypeReference<PropertySearchResult>(){}, "Failed to search artifact by the properties '" + properties + "'", false);
        return result;
    }

    public AqlSearchResult searchArtifactsByAql(String aql) throws IOException {
        PreemptiveHttpClient client = this.httpClient.getHttpClient();
        String url = this.artifactoryUrl + "/api/search/aql";
        HttpPost httpPost = new HttpPost(url);
        StringEntity entity = new StringEntity(aql);
        httpPost.setEntity((HttpEntity)entity);
        AqlSearchResult result = this.readResponse(client.execute((HttpUriRequest)httpPost), new TypeReference<AqlSearchResult>(){}, "Failed to search artifact by the aql '" + aql + "'", true);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T readResponse(HttpResponse response, TypeReference<T> valueType, String errorMessage, boolean ignorMissingFields) throws IOException {
        if (response.getStatusLine().getStatusCode() == 200) {
            HttpEntity entity = response.getEntity();
            if (entity == null) {
                return null;
            }
            InputStream content = null;
            try {
                content = entity.getContent();
                JsonParser parser = this.httpClient.createJsonParser(content);
                if (ignorMissingFields) {
                    ((ObjectMapper)parser.getCodec()).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
                }
                Object object = parser.readValueAs(valueType);
                return (T)object;
            }
            finally {
                if (content != null) {
                    IOUtils.closeQuietly((InputStream)content);
                }
            }
        }
        HttpEntity httpEntity = response.getEntity();
        if (httpEntity != null) {
            IOUtils.closeQuietly((InputStream)httpEntity.getContent());
        }
        throw new IOException(errorMessage + ": " + response.getStatusLine());
    }

    public HttpResponse downloadArtifact(String downloadUrl) throws IOException {
        return this.execute(downloadUrl, false);
    }

    public HttpResponse getArtifactChecksums(String artifactUrl) throws IOException {
        return this.execute(artifactUrl, true);
    }

    public boolean isArtifactoryOSS() throws IOException {
        return !this.httpClient.getVersion().hasAddons();
    }

    private HttpResponse execute(String artifactUrl, boolean isHead) throws IOException {
        PreemptiveHttpClient client = this.httpClient.getHttpClient();
        artifactUrl = ArtifactoryHttpClient.encodeUrl((String)artifactUrl);
        HttpHead httpRequest = isHead ? new HttpHead(artifactUrl) : new HttpGet(artifactUrl);
        httpRequest.setHeader("Connection", "Keep-Alive");
        HttpResponse response = client.execute((HttpUriRequest)httpRequest);
        StatusLine statusLine = response.getStatusLine();
        int statusCode = statusLine.getStatusCode();
        if (statusCode == 404) {
            EntityUtils.consume((HttpEntity)response.getEntity());
            throw new FileNotFoundException("Unable to find " + artifactUrl);
        }
        if (statusCode != 200) {
            EntityUtils.consume((HttpEntity)response.getEntity());
            throw new IOException("Error downloading " + artifactUrl + ". Code: " + statusCode + " Message: " + statusLine.getReasonPhrase());
        }
        return response;
    }
}

