/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.clientConfiguration;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jfrog.build.extractor.clientConfiguration.PatternMatcher;

public class ArtifactSpec {
    public static final String CONFIG_ALL = "all";
    public static final String WILDCARD = "*";
    private static final Pattern ARTIFACT_NOTATION = Pattern.compile("^([^:]+):([^:]+):([^:]+):([^:]+?)(?:\\@([^:]+$)){0,1}$");
    private final Map<String, CharSequence> properties = new HashMap<String, CharSequence>();
    private String group;
    private String name;
    private String version;
    private String classifier;
    private String type;
    private String configuration;

    private ArtifactSpec() {
    }

    public static ArtifactSpec newSpec(String notation) {
        String[] splits = notation.split("\\s+", 3);
        ArtifactSpec spec = null;
        if (splits.length >= 2) {
            Builder builder = ArtifactSpec.builder();
            if (splits[1].contains(",")) {
                builder.configuration(WILDCARD);
                builder.artifactNotation(splits[0]);
                builder.properties(notation.substring(notation.indexOf(splits[1])));
                spec = builder.build();
            } else if (splits.length == 3) {
                builder.configuration(splits[0].equalsIgnoreCase(CONFIG_ALL) ? WILDCARD : splits[0]);
                builder.artifactNotation(splits[1]);
                builder.properties(splits[2]);
                spec = builder.build();
            }
        }
        if (spec == null) {
            throw new IllegalArgumentException("Artifact spec notation '" + notation + "' is wrong.\nExpecting notation in the format of: " + "'[configName] artifactNotation key1:val1, key2:val2, key3:val3 ...'");
        }
        return spec;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean matches(ArtifactSpec spec) {
        return this.specValueMatch(this.configuration, spec.configuration) && this.specValueMatch(this.group, spec.group) && this.specValueMatch(this.name, spec.name) && this.specValueMatch(this.version, spec.version) && this.specValueMatch(this.classifier, spec.classifier) && this.specValueMatch(this.type, spec.type);
    }

    private boolean specValueMatch(String pattern, String str) {
        if (pattern == null || WILDCARD.equals(pattern)) {
            return true;
        }
        if (str == null || WILDCARD.equals(str)) {
            return false;
        }
        return PatternMatcher.match(pattern, str, false);
    }

    public String getConfiguration() {
        return this.configuration;
    }

    public String getGroup() {
        return this.group;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public String getType() {
        return this.type;
    }

    public Map<String, CharSequence> getProperties() {
        return this.properties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ArtifactSpec)) {
            return false;
        }
        ArtifactSpec spec = (ArtifactSpec)o;
        if (this.classifier != null ? !this.classifier.equals(spec.classifier) : spec.classifier != null) {
            return false;
        }
        if (this.group != null ? !this.group.equals(spec.group) : spec.group != null) {
            return false;
        }
        if (!this.name.equals(spec.name)) {
            return false;
        }
        if (this.type != null ? !this.type.equals(spec.type) : spec.type != null) {
            return false;
        }
        return this.version.equals(spec.version);
    }

    public int hashCode() {
        int result = this.group != null ? this.group.hashCode() : 0;
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.version.hashCode();
        result = 31 * result + (this.classifier != null ? this.classifier.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        return result;
    }

    public static class Builder {
        private ArtifactSpec spec = new ArtifactSpec();

        private Builder() {
        }

        public ArtifactSpec build() {
            return this.spec;
        }

        public Builder artifactNotation(String artifactNotation) {
            Matcher matcher = ARTIFACT_NOTATION.matcher(artifactNotation);
            int matchGroups = matcher.groupCount();
            if (!matcher.matches() || matchGroups != 5) {
                throw new IllegalArgumentException("Invalid module notation: " + artifactNotation + ". Expected: group:artifact:version:classifier[@ext].");
            }
            this.group(matcher.group(1));
            this.name(matcher.group(2));
            this.version(matcher.group(3));
            this.classifier(matcher.group(4));
            this.type(matcher.group(5));
            return this;
        }

        public Builder group(String group) {
            this.spec.group = group != null ? group : ArtifactSpec.WILDCARD;
            return this;
        }

        public Builder name(String name) {
            this.spec.name = name != null ? name : ArtifactSpec.WILDCARD;
            return this;
        }

        public Builder version(String version) {
            this.spec.version = version != null ? version : ArtifactSpec.WILDCARD;
            return this;
        }

        public Builder classifier(String classifier) {
            this.spec.classifier = classifier != null ? classifier : ArtifactSpec.WILDCARD;
            return this;
        }

        public Builder type(String type) {
            this.spec.type = type != null ? type : ArtifactSpec.WILDCARD;
            return this;
        }

        public Builder configuration(String configuration) {
            this.spec.configuration = configuration != null && !configuration.equalsIgnoreCase(ArtifactSpec.CONFIG_ALL) ? configuration : ArtifactSpec.WILDCARD;
            return this;
        }

        public Builder properties(Map<String, String> properties) {
            if (properties == null) {
                throw new IllegalArgumentException("Properties cannot be null");
            }
            this.spec.properties.putAll(properties);
            return this;
        }

        public void properties(String propsString) {
            String[] keyVals = propsString.split(",");
            HashMap<String, String> props = new HashMap<String, String>(keyVals.length);
            for (String keyVal : keyVals) {
                String[] kv = keyVal.split(":");
                if (kv.length != 2) {
                    throw new IllegalArgumentException("Illegal key-vals format: " + propsString + "(" + keyVal + "). Expected: key1:val1, key2:val2, ...");
                }
                props.put(kv[0].trim(), kv[1].trim());
            }
            this.spec.properties.putAll(props);
        }
    }
}

