/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.usageReport;

import java.io.IOException;
import javax.net.ssl.SSLContext;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.client.ProxyConfiguration;
import org.jfrog.build.extractor.clientConfiguration.client.artifactory.ArtifactoryManager;

public class UsageReporter {
    private final String productId;
    private FeatureId[] features;

    public UsageReporter(String productId, String[] featureIds) {
        this.productId = productId;
        this.setFeatures(featureIds);
    }

    public void reportUsage(String artifactoryUrl, String username, String password, String accessToken, ProxyConfiguration proxyConfiguration, SSLContext sslContext, Log log) throws IOException {
        try (ArtifactoryManager artifactoryManager = new ArtifactoryManager(artifactoryUrl, username, password, accessToken, log);){
            if (proxyConfiguration != null) {
                artifactoryManager.setProxyConfiguration(proxyConfiguration);
            }
            if (sslContext != null) {
                artifactoryManager.setSslContext(sslContext);
            }
            artifactoryManager.reportUsage(this);
        }
    }

    public String getProductId() {
        return this.productId;
    }

    public FeatureId[] getFeatures() {
        return this.features;
    }

    private void setFeatures(String[] featureIds) {
        this.features = new FeatureId[featureIds.length];
        int featureIndex = 0;
        for (String featureId : featureIds) {
            this.features[featureIndex] = new FeatureId(featureId);
            ++featureIndex;
        }
    }

    public static class FeatureId {
        private final String featureId;

        public FeatureId(String featureId) {
            this.featureId = featureId;
        }

        public String getFeatureId() {
            return this.featureId;
        }
    }
}

