/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.clientConfiguration.client.distribution;

import java.io.IOException;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.extractor.clientConfiguration.client.ManagerBase;
import org.jfrog.build.extractor.clientConfiguration.client.distribution.request.CreateReleaseBundleRequest;
import org.jfrog.build.extractor.clientConfiguration.client.distribution.request.DeleteReleaseBundleRequest;
import org.jfrog.build.extractor.clientConfiguration.client.distribution.request.DistributeReleaseBundleRequest;
import org.jfrog.build.extractor.clientConfiguration.client.distribution.request.UpdateReleaseBundleRequest;
import org.jfrog.build.extractor.clientConfiguration.client.distribution.response.DistributeReleaseBundleResponse;
import org.jfrog.build.extractor.clientConfiguration.client.distribution.response.DistributionStatusResponse;
import org.jfrog.build.extractor.clientConfiguration.client.distribution.response.GetReleaseBundleStatusResponse;
import org.jfrog.build.extractor.clientConfiguration.client.distribution.services.CreateReleaseBundle;
import org.jfrog.build.extractor.clientConfiguration.client.distribution.services.DeleteLocalReleaseBundle;
import org.jfrog.build.extractor.clientConfiguration.client.distribution.services.DeleteReleaseBundle;
import org.jfrog.build.extractor.clientConfiguration.client.distribution.services.DistributeReleaseBundle;
import org.jfrog.build.extractor.clientConfiguration.client.distribution.services.GetDistributionStatus;
import org.jfrog.build.extractor.clientConfiguration.client.distribution.services.GetReleaseBundleVersion;
import org.jfrog.build.extractor.clientConfiguration.client.distribution.services.SignReleaseBundle;
import org.jfrog.build.extractor.clientConfiguration.client.distribution.services.UpdateReleaseBundle;
import org.jfrog.build.extractor.clientConfiguration.client.distribution.services.Version;

public class DistributionManager
extends ManagerBase {
    public DistributionManager(String url, String username, String password, String accessToken, Log logger) {
        super(url, username, password, accessToken, logger);
    }

    public DistributionManager(String url, String username, String password, Log log) {
        super(url, username, password, "", log);
    }

    public DistributionManager(String url, String accessToken, Log log) {
        super(url, "", "", accessToken, log);
    }

    public DistributionManager(String url, Log log) {
        super(url, "", "", "", log);
    }

    @Override
    public org.jfrog.build.client.Version getVersion() throws IOException {
        Version versionService = new Version(this.log);
        return (org.jfrog.build.client.Version)versionService.execute(this.jfrogHttpClient);
    }

    public void createReleaseBundle(CreateReleaseBundleRequest request, String gpgPassphrase) throws IOException {
        new CreateReleaseBundle(request, gpgPassphrase, this.log).execute(this.jfrogHttpClient);
    }

    public void createReleaseBundle(CreateReleaseBundleRequest request) throws IOException {
        this.createReleaseBundle(request, "");
    }

    public void updateReleaseBundle(String name, String version, UpdateReleaseBundleRequest request, String gpgPassphrase) throws IOException {
        new UpdateReleaseBundle(request, name, version, gpgPassphrase, this.log).execute(this.jfrogHttpClient);
    }

    public void updateReleaseBundle(String name, String version, UpdateReleaseBundleRequest request) throws IOException {
        this.updateReleaseBundle(name, version, request, "");
    }

    public void signReleaseBundle(String name, String version, String gpgPassphrase, String storingRepository) throws IOException {
        new SignReleaseBundle(name, version, gpgPassphrase, storingRepository, this.log).execute(this.jfrogHttpClient);
    }

    public void signReleaseBundle(String name, String version, String gpgPassphrase) throws IOException {
        this.signReleaseBundle(name, version, gpgPassphrase, "");
    }

    public GetReleaseBundleStatusResponse getReleaseBundleStatus(String name, String version) throws IOException {
        return (GetReleaseBundleStatusResponse)new GetReleaseBundleVersion(name, version, this.log).execute(this.jfrogHttpClient);
    }

    public DistributeReleaseBundleResponse distributeReleaseBundle(String name, String version, boolean sync, DistributeReleaseBundleRequest request) throws IOException {
        return new DistributeReleaseBundle(name, version, sync, request, this.log).execute(this.jfrogHttpClient);
    }

    public DistributionStatusResponse getDistributionStatus(String name, String version) throws IOException {
        return (DistributionStatusResponse)new GetDistributionStatus(name, version, "", this.log).execute(this.jfrogHttpClient);
    }

    public DistributionStatusResponse getDistributionStatus(String name, String version, String trackerId) throws IOException {
        return (DistributionStatusResponse)new GetDistributionStatus(name, version, trackerId, this.log).execute(this.jfrogHttpClient);
    }

    public void deleteLocalReleaseBundle(String name, String version) throws IOException {
        new DeleteLocalReleaseBundle(name, version, this.log).execute(this.jfrogHttpClient);
    }

    public DistributeReleaseBundleResponse deleteReleaseBundle(String name, String version, boolean sync, DeleteReleaseBundleRequest request) throws IOException {
        return new DeleteReleaseBundle(name, version, sync, request, this.log).execute(this.jfrogHttpClient);
    }
}

