/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.clientConfiguration;

import java.io.Serializable;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.StringUtils;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.client.ProxyConfiguration;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryClientConfiguration;
import org.jfrog.build.extractor.clientConfiguration.client.ManagerBase;

public abstract class ManagerBuilderBase<T extends ManagerBuilderBase<T>>
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected ProxyConfiguration proxyConfiguration;
    protected int connectionTimeout = -1;
    protected int connectionRetry = -1;
    protected String serverUrl;
    protected SSLContext sslContext;
    protected String username;
    protected String password;
    protected String accessToken;
    protected Log log;

    public T setProxyConfiguration(ProxyConfiguration proxyConfiguration) {
        this.proxyConfiguration = proxyConfiguration;
        return this.self();
    }

    public T setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        return this.self();
    }

    public T setConnectionRetry(int connectionRetry) {
        this.connectionRetry = connectionRetry;
        return this.self();
    }

    public T setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
        return this.self();
    }

    public T setSslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
        return this.self();
    }

    public T setUsername(String username) {
        this.username = username;
        return this.self();
    }

    public T setPassword(String password) {
        this.password = password;
        return this.self();
    }

    public T setAccessToken(String accessToken) {
        this.accessToken = accessToken;
        return this.self();
    }

    public T setLog(Log log) {
        this.log = log;
        return this.self();
    }

    public T setClientConfiguration(ArtifactoryClientConfiguration clientConfiguration, ArtifactoryClientConfiguration.RepositoryConfiguration repositoryConfiguration) {
        this.setServerUrl(repositoryConfiguration.getContextUrl());
        this.setUsername(repositoryConfiguration.getUsername());
        this.setPassword(repositoryConfiguration.getPassword());
        this.setLog(repositoryConfiguration.getLog());
        ArtifactoryClientConfiguration.ProxyHandler proxyHandler = clientConfiguration.proxy;
        if (proxyHandler != null && StringUtils.isNotBlank((CharSequence)proxyHandler.getHost())) {
            ProxyConfiguration proxyConfiguration = new ProxyConfiguration();
            proxyConfiguration.host = proxyHandler.getHost();
            proxyConfiguration.port = proxyHandler.getPort();
            proxyConfiguration.username = proxyHandler.getUsername();
            proxyConfiguration.password = proxyHandler.getPassword();
            this.setProxyConfiguration(proxyConfiguration);
        }
        if (clientConfiguration.getConnectionRetries() != null) {
            this.setConnectionRetry(clientConfiguration.getConnectionRetries());
        }
        if (clientConfiguration.getTimeout() != null) {
            this.setConnectionTimeout(clientConfiguration.getTimeout());
        }
        return this.self();
    }

    protected ManagerBase build(ManagerBase client) {
        if (this.proxyConfiguration != null) {
            client.setProxyConfiguration(this.proxyConfiguration.host, this.proxyConfiguration.port, this.proxyConfiguration.username, this.proxyConfiguration.password);
        }
        client.setSslContext(this.sslContext);
        if (this.connectionTimeout != -1) {
            client.setConnectionTimeout(this.connectionTimeout);
        }
        if (this.connectionRetry != -1) {
            client.setConnectionRetries(this.connectionRetry);
        }
        return client;
    }

    public abstract ManagerBase build();

    protected abstract T self();
}

