/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.clientConfiguration;

import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jfrog.build.api.multiMap.ListMultimap;
import org.jfrog.build.api.multiMap.Multimap;
import org.jfrog.build.extractor.clientConfiguration.ArtifactSpec;

public class ArtifactSpecs
extends LinkedList<ArtifactSpec> {
    public ArtifactSpecs() {
    }

    public ArtifactSpecs(String specsNotation) {
        if (StringUtils.isNotBlank((CharSequence)specsNotation)) {
            String[] notations;
            for (String notation : notations = specsNotation.split("\r{0,1}\n")) {
                if (!StringUtils.isNotBlank((CharSequence)notation)) continue;
                ArtifactSpec spec = ArtifactSpec.newSpec(notation);
                this.add(spec);
            }
        }
    }

    public Multimap<String, CharSequence> getProperties(ArtifactSpec spec) {
        ListMultimap props = new ListMultimap();
        for (ArtifactSpec matcherSpec : this) {
            if (!matcherSpec.matches(spec)) continue;
            Map<String, CharSequence> matcherSpecProperties = matcherSpec.getProperties();
            for (Map.Entry<String, CharSequence> entry : matcherSpecProperties.entrySet()) {
                props.put((Object)entry.getKey(), (Object)entry.getValue());
            }
        }
        return props;
    }
}

