/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.clientConfiguration.util;

import java.io.IOException;
import java.util.List;
import org.jfrog.build.api.search.AqlSearchResult;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.extractor.clientConfiguration.client.artifactory.ArtifactoryManager;
import org.jfrog.build.extractor.clientConfiguration.util.ArtifactorySearcher;
import org.jfrog.filespecs.FileSpec;
import org.jfrog.filespecs.entities.FilesGroup;

public class EditPropertiesHelper {
    private final ArtifactoryManager artifactoryManager;
    private final Log log;

    public EditPropertiesHelper(ArtifactoryManager artifactoryManager, Log log) {
        this.artifactoryManager = artifactoryManager;
        this.log = log;
    }

    public boolean editProperties(FileSpec spec, EditPropertiesActionType editType, String props) throws IOException {
        ArtifactorySearcher searcher = new ArtifactorySearcher(this.artifactoryManager, this.log);
        boolean propertiesSet = false;
        for (FilesGroup file : spec.getFiles()) {
            this.log.debug("Editing properties using spec: \n" + file.toString());
            if (editType == EditPropertiesActionType.SET) {
                propertiesSet = this.setPropertiesOnResults(searcher.SearchByFileSpec(file), props) || propertiesSet;
                continue;
            }
            propertiesSet = this.deletePropertiesOnResults(searcher.SearchByFileSpec(file), props) || propertiesSet;
        }
        return propertiesSet;
    }

    private boolean setPropertiesOnResults(List<AqlSearchResult.SearchEntry> searchResults, String props) throws IOException {
        boolean propertiesSet = false;
        this.log.info("Setting properties...");
        for (AqlSearchResult.SearchEntry result : searchResults) {
            String relativePath = this.buildEntryUrl(result);
            this.log.info(String.format("Setting the properties: '%s', on artifact: %s", props, relativePath));
            this.artifactoryManager.setProperties(relativePath, props, true);
            propertiesSet = true;
        }
        this.log.info("Done setting properties.");
        return propertiesSet;
    }

    private boolean deletePropertiesOnResults(List<AqlSearchResult.SearchEntry> searchResults, String props) throws IOException {
        boolean propertiesSet = false;
        this.log.info("Deleting properties...");
        for (AqlSearchResult.SearchEntry result : searchResults) {
            String relativePath = this.buildEntryUrl(result);
            this.log.info(String.format("Deleting the properties: '%s', on artifact: %s", props, relativePath));
            this.artifactoryManager.deleteProperties(relativePath, props);
            propertiesSet = true;
        }
        this.log.info("Done deleting properties.");
        return propertiesSet;
    }

    private String buildEntryUrl(AqlSearchResult.SearchEntry result) {
        String path = result.getPath().equals(".") ? "" : result.getPath() + "/";
        return result.getRepo() + "/" + path + result.getName();
    }

    public static enum EditPropertiesActionType {
        SET,
        DELETE;

    }
}

