/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.clientConfiguration.client.distribution.services;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpRequestBase;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.client.JFrogHttpClient;
import org.jfrog.build.extractor.clientConfiguration.client.distribution.response.DistributionStatusResponse;
import org.jfrog.build.extractor.clientConfiguration.client.distribution.services.VoidDistributionService;

public class DeleteLocalReleaseBundle
extends VoidDistributionService {
    private static final String GET_STATUS_ENDPOINT = "api/v1/release_bundle";
    private final String version;
    private final String name;

    public DeleteLocalReleaseBundle(String name, String version, Log logger) {
        super(logger);
        this.name = name;
        this.version = version;
    }

    @Override
    protected void ensureRequirements(JFrogHttpClient client) throws IOException {
        if (StringUtils.isBlank((CharSequence)this.name)) {
            throw new IOException("Release bundle name is mandatory");
        }
        if (StringUtils.isBlank((CharSequence)this.version)) {
            throw new IOException("Release bundle version is mandatory");
        }
    }

    @Override
    public HttpRequestBase createRequest() throws IOException {
        return new HttpDelete(this.buildUrlForDelete());
    }

    @Override
    protected void setResponse(InputStream stream) throws IOException {
        this.result = this.getMapper().readValue(stream, (JavaType)TypeFactory.defaultInstance().constructCollectionLikeType(List.class, DistributionStatusResponse.class));
    }

    private String buildUrlForDelete() {
        String url = GET_STATUS_ENDPOINT;
        if (StringUtils.isEmpty((CharSequence)this.name)) {
            return url;
        }
        url = url + "/" + this.name;
        if (StringUtils.isEmpty((CharSequence)this.version)) {
            return url;
        }
        return url + "/" + this.version;
    }
}

