/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.ci;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class BuildRetention
implements Serializable {
    private int count = -1;
    private Date minimumBuildDate;
    private boolean deleteBuildArtifacts;
    private List<String> buildNumbersNotToBeDiscarded = new ArrayList<String>();

    public BuildRetention() {
    }

    public BuildRetention(boolean deleteBuildArtifacts) {
        this.deleteBuildArtifacts = deleteBuildArtifacts;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public Date getMinimumBuildDate() {
        return this.minimumBuildDate;
    }

    public void setMinimumBuildDate(Date minimumBuildDate) {
        this.minimumBuildDate = minimumBuildDate;
    }

    public void setDeleteBuildArtifacts(boolean deleteBuildArtifacts) {
        this.deleteBuildArtifacts = deleteBuildArtifacts;
    }

    public boolean isDeleteBuildArtifacts() {
        return this.deleteBuildArtifacts;
    }

    public void addBuildNotToBeDiscarded(String buildNumber) {
        this.buildNumbersNotToBeDiscarded.add(buildNumber);
    }

    public void setBuildNumbersNotToBeDiscarded(List<String> buildNumbersNotToBeDiscarded) {
        if (buildNumbersNotToBeDiscarded == null) {
            this.buildNumbersNotToBeDiscarded = new ArrayList<String>();
            return;
        }
        this.buildNumbersNotToBeDiscarded = buildNumbersNotToBeDiscarded;
    }

    public List<String> getBuildNumbersNotToBeDiscarded() {
        return this.buildNumbersNotToBeDiscarded;
    }

    @JsonIgnore
    public boolean isEmpty() {
        return this.count == -1 && this.minimumBuildDate == null;
    }

    public org.jfrog.build.api.BuildRetention ToBuildRetention() {
        org.jfrog.build.api.BuildRetention result = new org.jfrog.build.api.BuildRetention();
        result.setDeleteBuildArtifacts(this.deleteBuildArtifacts);
        result.setCount(this.count);
        result.setMinimumBuildDate(this.minimumBuildDate);
        result.setBuildNumbersNotToBeDiscarded(this.buildNumbersNotToBeDiscarded);
        return result;
    }

    public static BuildRetention ToBuildInfoRetention(org.jfrog.build.api.BuildRetention br) {
        BuildRetention result = new BuildRetention();
        result.setDeleteBuildArtifacts(br.isDeleteBuildArtifacts());
        result.setCount(br.getCount());
        result.setMinimumBuildDate(br.getMinimumBuildDate());
        result.setBuildNumbersNotToBeDiscarded(br.getBuildNumbersNotToBeDiscarded());
        return result;
    }
}

