/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.clientConfiguration.util.spec;

import com.google.common.collect.Multimap;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.jfrog.build.extractor.clientConfiguration.deploy.DeployDetails;
import org.jfrog.build.extractor.clientConfiguration.util.PathsUtils;
import org.jfrog.build.extractor.clientConfiguration.util.spec.UploadSpecHelper;
import org.jfrog.build.extractor.producerConsumer.ProducerConsumerExecutor;
import org.jfrog.filespecs.entities.FilesGroup;

public class SingleSpecDeploymentProducer {
    private FilesGroup spec;
    private File workspace;
    private Multimap<String, String> buildProperties;
    private Pattern regexpPattern;
    private Pattern regexpExcludePattern;
    private Pattern pathPattern;
    private String targetPath;
    private String baseDir;
    private File baseDirFile;
    private boolean isTargetDirectory;
    private boolean isFlat;
    private boolean isRecursive;
    private boolean isRegexp;
    private boolean isAbsolutePath;
    private int separatorsCount;
    private Set<String> symlinkSet = new HashSet<String>();

    SingleSpecDeploymentProducer(FilesGroup spec, File workspace, Multimap<String, String> buildProperties) {
        this.spec = spec;
        this.workspace = workspace;
        this.buildProperties = buildProperties;
    }

    public void executeSpec(Set<DeployDetails> deploymentSet, ProducerConsumerExecutor executor) throws IOException, NoSuchAlgorithmException, InterruptedException {
        this.init();
        File[] filesToScan = new File(this.baseDir).listFiles();
        if (filesToScan == null) {
            return;
        }
        for (File file : filesToScan) {
            if (Thread.interrupted()) {
                Thread.currentThread().interrupt();
                break;
            }
            if (file.isFile()) {
                this.processDeployCandidate(file, deploymentSet, executor);
                continue;
            }
            if (this.isRecursive) {
                this.collectFiles(file.getAbsolutePath(), -1, deploymentSet, executor);
                continue;
            }
            if (this.isRegexp) continue;
            this.collectFiles(file.getAbsolutePath(), this.separatorsCount, deploymentSet, executor);
        }
    }

    private void init() throws FileNotFoundException {
        String patternForPath;
        String newPattern;
        this.isFlat = !"false".equalsIgnoreCase(this.spec.getFlat());
        this.isRecursive = !"false".equalsIgnoreCase(this.spec.getRecursive());
        this.isRegexp = BooleanUtils.toBoolean((String)this.spec.getRegexp());
        this.targetPath = UploadSpecHelper.getLocalPath(this.spec.getTarget());
        this.isTargetDirectory = StringUtils.endsWith((CharSequence)this.targetPath, (CharSequence)"/");
        String pattern = this.spec.getPattern();
        this.isAbsolutePath = new File(pattern).isAbsolute();
        if (this.isRegexp) {
            this.baseDir = UploadSpecHelper.getRegexBaseDir(this.workspace, pattern);
            newPattern = UploadSpecHelper.prepareRegexPattern(this.workspace, pattern, this.baseDir);
            this.regexpPattern = Pattern.compile(newPattern);
            patternForPath = pattern;
        } else {
            this.baseDir = UploadSpecHelper.getWildcardBaseDir(this.workspace, pattern);
            newPattern = UploadSpecHelper.prepareWildcardPattern(this.workspace, pattern, this.baseDir);
            this.regexpPattern = Pattern.compile(PathsUtils.pathToRegExp(newPattern));
            patternForPath = PathsUtils.pathToRegExp(pattern);
        }
        this.separatorsCount = StringUtils.countMatches((CharSequence)newPattern, (CharSequence)"/") + StringUtils.countMatches((CharSequence)this.baseDir, (CharSequence)"/");
        this.pathPattern = Pattern.compile(patternForPath);
        Object[] exclusions = this.spec.getExclusions();
        if (ArrayUtils.isEmpty((Object[])exclusions)) {
            exclusions = this.spec.getExcludePatterns();
        }
        String excludePattern = UploadSpecHelper.prepareExcludePattern((String[])exclusions, !this.isRegexp, this.isRecursive);
        this.regexpExcludePattern = StringUtils.isBlank((CharSequence)excludePattern) ? null : Pattern.compile(excludePattern);
        this.baseDirFile = new File(this.baseDir);
    }

    private void collectFiles(String dir, int depth, Set<DeployDetails> deploymentSet, ProducerConsumerExecutor executor) throws IOException, NoSuchAlgorithmException, InterruptedException {
        LinkedList<String> foldersToScan = new LinkedList<String>();
        foldersToScan.add(dir);
        block0: for (int i = 0; i < foldersToScan.size(); ++i) {
            if (Thread.interrupted()) {
                Thread.currentThread().interrupt();
                break;
            }
            String folderString = (String)foldersToScan.get(i);
            if (depth != -1 && StringUtils.countMatches((CharSequence)folderString, (CharSequence)File.separator) > depth) continue;
            File file = new File(folderString);
            ArrayList<File> folderContent = new ArrayList<File>();
            File[] fileList = file.listFiles();
            if (fileList != null) {
                folderContent.addAll(Arrays.asList(fileList));
            }
            if (folderContent.isEmpty()) continue;
            for (File entry : folderContent) {
                if (Thread.interrupted()) {
                    Thread.currentThread().interrupt();
                    continue block0;
                }
                if (entry.isDirectory()) {
                    if (Files.isSymbolicLink(entry.toPath()) && !this.symlinkSet.add(entry.getCanonicalPath())) continue;
                    foldersToScan.add(entry.getAbsolutePath());
                    continue;
                }
                if (depth != -1 && StringUtils.countMatches((CharSequence)entry.getPath(), (CharSequence)File.separator) != depth) continue;
                this.processDeployCandidate(entry, deploymentSet, executor);
            }
        }
    }

    private void processDeployCandidate(File file, Set<DeployDetails> deploymentSet, ProducerConsumerExecutor executor) throws IOException, NoSuchAlgorithmException, InterruptedException {
        String filePath = file.getAbsolutePath().replace("\\", "/");
        if (!SingleSpecDeploymentProducer.isFileMatchPattern(filePath, this.regexpPattern, this.regexpExcludePattern, this.workspace, this.baseDirFile)) {
            return;
        }
        String uploadPath = UploadSpecHelper.getUploadPath(file, this.pathPattern, this.targetPath, this.isFlat, this.isAbsolutePath, this.workspace, this.isTargetDirectory);
        DeployDetails deployDetails = UploadSpecHelper.buildDeployDetails(uploadPath, file, this.spec.getTarget(), this.spec.getExplode(), this.spec.getProps(), this.buildProperties);
        if (deploymentSet.add(deployDetails)) {
            SingleSpecDeploymentProducer.validateUploadLimit(deploymentSet.size());
            executor.put(deployDetails);
        }
    }

    private static boolean isFileMatchPattern(String filePath, Pattern regexpPattern, Pattern regexpExcludePattern, File workspaceDir, File baseDirFile) {
        File file = new File(filePath);
        String relativePath = UploadSpecHelper.getRelativePath(baseDirFile, file).replace("\\", "/");
        if (!regexpPattern.matcher(relativePath).matches()) {
            return false;
        }
        if (regexpExcludePattern != null) {
            boolean fileInWs = file.getAbsolutePath().startsWith(workspaceDir.getAbsolutePath());
            String relativeToWsPath = fileInWs ? UploadSpecHelper.getRelativeToWsPath(file.getAbsolutePath(), workspaceDir.getAbsolutePath()) : file.getAbsolutePath();
            return !regexpExcludePattern.matcher(relativeToWsPath).matches();
        }
        return true;
    }

    private static void validateUploadLimit(int numberOfFiles) {
        int filesLimit = 1000000;
        if (numberOfFiles >= filesLimit) {
            throw new IllegalStateException("Too many artifacts to deploy were found.");
        }
    }
}

