/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.clientConfiguration.client.artifactory.services;

import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.client.ItemLastModified;
import org.jfrog.build.extractor.clientConfiguration.client.JFrogService;

public class GetItemLastModified
extends JFrogService<ItemLastModified> {
    public static final String ITEM_LAST_MODIFIED = "api/storage/";
    private final String path;

    public GetItemLastModified(String path, Log logger) {
        super(logger);
        this.path = path;
    }

    @Override
    public HttpRequestBase createRequest() {
        return new HttpGet(ITEM_LAST_MODIFIED + this.path + "?lastModified");
    }

    @Override
    protected void handleEmptyEntity() throws IOException {
        throw new IOException("The path " + this.path + " returned empty entity");
    }

    @Override
    protected void setResponse(InputStream stream) throws IOException {
        this.result = this.getMapper().readValue(stream, ItemLastModified.class);
        try {
            if (((ItemLastModified)this.result).getLastModified() == 0L || ((ItemLastModified)this.result).getUri() == null) {
                throw new IOException("JSON response is missing URI or LastModified fields when requesting info for path " + this.path);
            }
        }
        catch (ParseException e) {
            throw new IOException("JSON response is missing URI or LastModified fields when requesting info for path " + this.path);
        }
    }

    @Override
    protected void handleUnsuccessfulResponse(HttpEntity entity) throws IOException {
        this.log.error("Failed while requesting item info for path: " + this.path);
        GetItemLastModified.throwException(entity, this.getStatusCode());
    }
}

