/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.clientConfiguration.util.spec;

import com.google.common.collect.Multimap;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.jfrog.build.extractor.clientConfiguration.deploy.DeployDetails;
import org.jfrog.build.extractor.clientConfiguration.util.spec.SingleSpecDeploymentProducer;
import org.jfrog.build.extractor.producerConsumer.ProducerRunnableBase;
import org.jfrog.filespecs.FileSpec;
import org.jfrog.filespecs.entities.FilesGroup;

public class SpecDeploymentProducer
extends ProducerRunnableBase {
    private Set<DeployDetails> deployDetailsSet = new HashSet<DeployDetails>();
    private FileSpec spec;
    private File workspace;
    private Multimap<String, String> buildProperties;

    SpecDeploymentProducer(FileSpec spec, File workspace, Multimap<String, String> buildProperties) {
        this.spec = spec;
        this.workspace = workspace;
        this.buildProperties = buildProperties;
    }

    @Override
    public void producerRun() throws InterruptedException {
        this.log.debug(String.format("[Thread %s] starting run()", Thread.currentThread().getName()));
        try {
            for (FilesGroup uploadFile : this.spec.getFiles()) {
                if (!Thread.interrupted()) {
                    this.log.debug(String.format("[Thread %s] getting deploy details from the following json: \n %s ", Thread.currentThread().getName(), uploadFile.toString()));
                    SingleSpecDeploymentProducer fileSpecProducer = new SingleSpecDeploymentProducer(uploadFile, this.workspace, this.buildProperties);
                    fileSpecProducer.executeSpec(this.deployDetailsSet, this.executor);
                    continue;
                }
                break;
            }
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Set<DeployDetails> getDeployedArtifacts() {
        return this.deployDetailsSet;
    }
}

