/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.clientConfiguration.deploy;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jfrog.build.client.DeployableArtifactDetail;
import org.jfrog.build.extractor.BuildInfoExtractorUtils;
import org.jfrog.build.extractor.clientConfiguration.deploy.DeployDetails;

public class DeployableArtifactsUtils {
    public static void saveDeployableArtifactsToFile(Map<String, Set<DeployDetails>> deployableArtifactsByModule, File toFile, boolean saveBackwardCompatible) throws IOException {
        if (saveBackwardCompatible) {
            DeployableArtifactsUtils.saveBackwardCompatibleDeployableArtifacts(deployableArtifactsByModule, toFile);
            return;
        }
        DeployableArtifactsUtils.saveDeployableArtifactsByModule(deployableArtifactsByModule, toFile);
    }

    private static void saveDeployableArtifactsByModule(Map<String, Set<DeployDetails>> deployableArtifactsByModule, File toFile) throws IOException {
        HashMap deployableArtifactsDetails = new HashMap();
        deployableArtifactsByModule.forEach((module, deployableArtifacts) -> deployableArtifactsDetails.put(module, DeployableArtifactsUtils.getDeployableArtifactsPaths(deployableArtifacts)));
        ObjectMapper mapper = BuildInfoExtractorUtils.createMapper();
        mapper.writeValue(toFile, deployableArtifactsDetails);
    }

    @Deprecated
    private static void saveBackwardCompatibleDeployableArtifacts(Map<String, Set<DeployDetails>> deployableArtifactsByModule, File toFile) throws IOException {
        ArrayList deployableArtifactsList = new ArrayList();
        deployableArtifactsByModule.forEach((module, deployableArtifacts) -> deployableArtifactsList.addAll(DeployableArtifactsUtils.getDeployableArtifactsPaths(deployableArtifacts)));
        ObjectMapper mapper = BuildInfoExtractorUtils.createMapper();
        mapper.writeValue(toFile, deployableArtifactsList);
    }

    public static Map<String, List<DeployableArtifactDetail>> loadDeployableArtifactsFromFile(File fromFile, File fromBackwardCompatibleFile) throws IOException {
        Map<String, List<DeployableArtifactDetail>> deployableArtifactsMap = DeployableArtifactsUtils.loadDeployableArtifactsByModuleFromFile(fromFile);
        if (deployableArtifactsMap.isEmpty()) {
            return DeployableArtifactsUtils.loadBackwardCompatibleDeployableArtifactsFromFile(fromBackwardCompatibleFile);
        }
        return deployableArtifactsMap;
    }

    private static Map<String, List<DeployableArtifactDetail>> loadDeployableArtifactsByModuleFromFile(File fromFile) throws IOException {
        if (fromFile == null || fromFile.length() == 0L) {
            return new HashMap<String, List<DeployableArtifactDetail>>();
        }
        ObjectMapper mapper = BuildInfoExtractorUtils.createMapper();
        return (Map)mapper.readValue(fromFile, (TypeReference)new TypeReference<Map<String, List<DeployableArtifactDetail>>>(){});
    }

    @Deprecated
    private static Map<String, List<DeployableArtifactDetail>> loadBackwardCompatibleDeployableArtifactsFromFile(File fromFile) throws IOException {
        if (fromFile == null || fromFile.length() == 0L) {
            return new HashMap<String, List<DeployableArtifactDetail>>();
        }
        ObjectMapper mapper = BuildInfoExtractorUtils.createMapper();
        List backwardCompatibleList = (List)mapper.readValue(fromFile, (TypeReference)new TypeReference<List<DeployableArtifactDetail>>(){});
        HashMap<String, List<DeployableArtifactDetail>> deployableArtifactMap = new HashMap<String, List<DeployableArtifactDetail>>();
        if (!backwardCompatibleList.isEmpty()) {
            deployableArtifactMap.put("", backwardCompatibleList);
        }
        return deployableArtifactMap;
    }

    private static List<DeployableArtifactDetail> getDeployableArtifactsPaths(Set<DeployDetails> deployDetails) {
        ArrayList<DeployableArtifactDetail> deployableArtifacts = new ArrayList<DeployableArtifactDetail>();
        for (DeployDetails artifact : deployDetails) {
            Map artifactProps = artifact.getProperties() != null ? artifact.getProperties().asMap() : Collections.emptyMap();
            deployableArtifacts.add(new DeployableArtifactDetail(artifact.getFile().getAbsolutePath(), artifact.getArtifactPath(), artifact.getSha1(), artifact.getSha256(), artifact.getDeploySucceeded(), artifact.getTargetRepository(), artifactProps));
        }
        return deployableArtifacts;
    }
}

