/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.buildScanTable;

import java.util.Objects;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.client.artifactoryXrayResponse.InfectedFile;
import org.jfrog.build.client.artifactoryXrayResponse.Issue;
import org.jfrog.build.extractor.buildScanTable.ScanTableBase;

public class SecurityViolationsTable
extends ScanTableBase {
    public static final String SECURITY_VIOLATIONS_TABLE_HEADLINE = "Security Violations";

    protected SecurityViolationsTable(Log log) {
        super(log);
    }

    @Override
    protected String getHeadline() {
        return SECURITY_VIOLATIONS_TABLE_HEADLINE;
    }

    @Override
    protected String[] getHeaders() {
        return new String[]{"#", "Severity", "Component", "CVE"};
    }

    @Override
    protected String getTableFormat() {
        return super.getFormatBase(this.longestDisplayName) + "%-20s";
    }

    @Override
    protected String getEmptyTableLine() {
        return "No security compliance violations were found";
    }

    protected void addElement(Issue issue, InfectedFile infectedFile) {
        SecurityTableElement element = new SecurityTableElement(infectedFile.getDisplayName(), infectedFile.getSha256(), issue.getSummary(), issue.getDescription(), issue.getCve());
        super.addElement(this.table, issue, element);
        if (infectedFile.getDisplayName() != null && infectedFile.getDisplayName().length() > this.longestDisplayName) {
            this.longestDisplayName = infectedFile.getDisplayName().length();
        }
    }

    protected void printTable() {
        super.printTable(this.table);
    }

    private static class SecurityTableElement
    extends ScanTableBase.TableElementBase {
        private final String cve;

        SecurityTableElement(String fileDisplayName, String fileSha256, String issueSummary, String issueDescription, String cve) {
            super(fileDisplayName, fileSha256, issueSummary, issueDescription);
            this.cve = cve;
        }

        private String getCve() {
            return this.cve == null ? "" : this.cve;
        }

        @Override
        protected Object[] getLineArgs(int line, String severityName) {
            return new Object[]{line, severityName, this.getFileDisplayName(), this.getCve()};
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SecurityTableElement that = (SecurityTableElement)o;
            return Objects.equals(this.fileDisplayName, that.fileDisplayName) && Objects.equals(this.fileSha256, that.fileSha256) && Objects.equals(this.issueSummary, that.issueSummary) && Objects.equals(this.issueDescription, that.issueDescription) && Objects.equals(this.cve, that.cve);
        }

        public int hashCode() {
            return Objects.hash(this.fileDisplayName, this.fileSha256, this.issueSummary, this.issueDescription, this.cve);
        }
    }
}

