/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.packageManager;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.jfrog.build.api.util.CommonUtils;
import org.jfrog.build.extractor.BuildInfoExtractorUtils;
import org.jfrog.build.extractor.ci.BuildInfo;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryClientConfiguration;
import org.jfrog.build.extractor.clientConfiguration.client.artifactory.ArtifactoryManager;
import org.jfrog.build.extractor.packageManager.PackageManagerUtils;

public abstract class PackageManagerExtractor
implements Serializable {
    private static final long serialVersionUID = 1L;

    public abstract BuildInfo execute();

    public void executeAndSaveBuildInfo(ArtifactoryClientConfiguration clientConfiguration) throws RuntimeException {
        CommonUtils.handleJavaTmpdirProperty();
        BuildInfo buildInfo = this.execute();
        if (buildInfo == null) {
            return;
        }
        PackageManagerUtils.collectEnvIfNeeded(clientConfiguration, buildInfo);
        PackageManagerExtractor.saveBuildInfoToFile(clientConfiguration, buildInfo);
    }

    static void saveBuildInfoToFile(ArtifactoryClientConfiguration clientConfiguration, BuildInfo buildInfo) {
        String generatedBuildInfoPath = clientConfiguration.info.getGeneratedBuildInfoFilePath();
        if (StringUtils.isBlank((CharSequence)generatedBuildInfoPath)) {
            return;
        }
        try {
            BuildInfoExtractorUtils.saveBuildInfoToFile(buildInfo, new File(generatedBuildInfoPath));
        }
        catch (Exception e) {
            clientConfiguration.getLog().error("Failed writing build info to file: ", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    protected static void validateRepoExists(ArtifactoryManager client, String repo, String repoNotSpecifiedMsg) throws IOException {
        if (StringUtils.isBlank((CharSequence)repo)) {
            throw new IllegalArgumentException(repoNotSpecifiedMsg);
        }
        if (!client.isRepositoryExist(repo)) {
            throw new IOException("Repo " + repo + " doesn't exist");
        }
    }
}

