/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor;

import java.util.BitSet;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.net.URLCodec;
import org.apache.commons.lang3.StringUtils;
import org.jfrog.build.util.URI;

public class UrlUtils {
    private static final Pattern CREDENTIALS_IN_URL_REGEX = Pattern.compile("(http|https|git)://.+@");
    private static final String BUILD_PROJECT_PARAM = "?project=";

    public static String removeCredentialsFromUrl(String lineWithCredentials) {
        Matcher matcher = CREDENTIALS_IN_URL_REGEX.matcher(lineWithCredentials);
        if (!matcher.find()) {
            return lineWithCredentials;
        }
        String credentialsPart = matcher.group();
        String protocol = matcher.group(1);
        return StringUtils.replace((String)lineWithCredentials, (String)credentialsPart, (String)(protocol + "://"));
    }

    public static void appendParamsToUrl(Map<String, String> requestParams, StringBuilder urlBuilder) {
        if (requestParams != null && !requestParams.isEmpty()) {
            urlBuilder.append("params=");
            Iterator<Map.Entry<String, String>> paramEntryIterator = requestParams.entrySet().iterator();
            String encodedPipe = UrlUtils.encodeUrl("|");
            while (paramEntryIterator.hasNext()) {
                Map.Entry<String, String> paramEntry = paramEntryIterator.next();
                urlBuilder.append(UrlUtils.encodeUrl(paramEntry.getKey()));
                String paramValue = paramEntry.getValue();
                if (StringUtils.isNotBlank((CharSequence)paramValue)) {
                    urlBuilder.append("=").append(UrlUtils.encodeUrl(paramValue));
                }
                if (!paramEntryIterator.hasNext()) continue;
                urlBuilder.append(encodedPipe);
            }
        }
    }

    public static String getProjectQueryParam(String project, String prefix) {
        return StringUtils.isEmpty((CharSequence)project) ? "" : prefix + UrlUtils.encodeUrl(project);
    }

    public static String getProjectQueryParam(String project) {
        return UrlUtils.getProjectQueryParam(project, BUILD_PROJECT_PARAM);
    }

    public static String encodeUrlPathPart(String pathPart) {
        byte[] rawData = URLCodec.encodeUrl(null, (byte[])org.apache.commons.codec.binary.StringUtils.getBytesUtf8((String)pathPart));
        return org.apache.commons.codec.binary.StringUtils.newStringUsAscii((byte[])rawData).replaceAll("\\+", "%20");
    }

    public static String encodeUrl(String url) {
        byte[] rawData = URLCodec.encodeUrl((BitSet)URI.allowed_query, (byte[])org.apache.commons.codec.binary.StringUtils.getBytesUtf8((String)url));
        return org.apache.commons.codec.binary.StringUtils.newStringUsAscii((byte[])rawData);
    }
}

