/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.clientConfiguration.client.artifactory.services;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.extractor.clientConfiguration.client.artifactory.services.DownloadBase;

public class DownloadToFile
extends DownloadBase<File> {
    private final String downloadTo;

    public DownloadToFile(String downloadFrom, String downloadTo, Map<String, String> headers, Log log) {
        super(downloadFrom, false, headers, log);
        this.downloadTo = downloadTo;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static File saveInputStreamToFile(InputStream inputStream, String filePath) throws IOException {
        File dest = new File(filePath);
        if (dest.exists()) {
            dest.delete();
        } else {
            dest.getParentFile().mkdirs();
        }
        try (FileOutputStream fileOutputStream = new FileOutputStream(dest);){
            IOUtils.copyLarge((InputStream)inputStream, (OutputStream)fileOutputStream);
            File file = dest;
            return file;
        }
        catch (IOException e) {
            throw new IOException(String.format("Could not create nor write to file: %s", dest.getCanonicalPath()), e);
        }
    }

    @Override
    protected void setResponse(InputStream stream) throws IOException {
        this.result = DownloadToFile.saveInputStreamToFile(stream, this.downloadTo);
    }
}

