/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.clientConfiguration.client.access.services;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.extractor.clientConfiguration.client.JFrogService;

public class GetProject
extends JFrogService<String> {
    private final String projectKey;

    public GetProject(String projectKey, Log logger) {
        super(logger);
        this.projectKey = projectKey;
        this.result = "";
    }

    @Override
    public HttpRequestBase createRequest() throws IOException {
        return new HttpGet("api/v1/projects/" + GetProject.encodeUrl(this.projectKey));
    }

    @Override
    protected void setResponse(InputStream stream) throws IOException {
        this.result = IOUtils.toString((InputStream)stream, (String)StandardCharsets.UTF_8.name());
    }

    @Override
    protected void handleUnsuccessfulResponse(HttpEntity entity) throws IOException {
        this.log.error("Failed get project with key: '" + this.projectKey + "'.");
        GetProject.throwException(entity, this.getStatusCode());
    }
}

