/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.release;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.jfrog.build.extractor.EolDetectingInputStream;

public class PropertiesTransformer {
    private final File propertiesFile;
    private final Map<String, String> versionsByName;

    public PropertiesTransformer(File propertiesFile, Map<String, String> versionsByName) {
        this.propertiesFile = propertiesFile;
        this.versionsByName = versionsByName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean transform() throws IOException, InterruptedException {
        if (!this.propertiesFile.exists()) {
            throw new IllegalArgumentException("Couldn't find properties file: " + this.propertiesFile.getAbsolutePath());
        }
        Properties properties = new Properties();
        EolDetectingInputStream eolDetectingInputStream = null;
        try {
            eolDetectingInputStream = new EolDetectingInputStream(new FileInputStream(this.propertiesFile));
            properties.load(eolDetectingInputStream);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(eolDetectingInputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)eolDetectingInputStream);
        String eol = eolDetectingInputStream.getEol();
        boolean hasEol = !"".equals(eol);
        StringBuilder resultBuilder = new StringBuilder();
        boolean modified = false;
        Enumeration<?> propertyNames = properties.propertyNames();
        while (propertyNames.hasMoreElements()) {
            String propertyName = (String)propertyNames.nextElement();
            String propertyValue = properties.getProperty(propertyName);
            StringBuilder lineBuilder = new StringBuilder(propertyName).append("=");
            String newPropertyValue = this.versionsByName.get(propertyName);
            if (newPropertyValue != null && !newPropertyValue.equals(propertyValue)) {
                if (!modified) {
                    modified = true;
                }
                lineBuilder.append(newPropertyValue);
            } else {
                lineBuilder.append(propertyValue);
            }
            resultBuilder.append(lineBuilder.toString());
            if (!hasEol) continue;
            resultBuilder.append(eol);
        }
        if (modified) {
            this.propertiesFile.delete();
            String toWrite = resultBuilder.toString();
            Files.write((CharSequence)toWrite, (File)this.propertiesFile, (Charset)Charsets.UTF_8);
        }
        return modified;
    }
}

