/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.scan;

import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jfrog.build.extractor.scan.GeneralInfo;
import org.jfrog.build.extractor.scan.Issue;
import org.jfrog.build.extractor.scan.License;
import org.jfrog.build.extractor.scan.Scope;

public class DependencyTree
extends DefaultMutableTreeNode {
    private Set<License> licenses = new HashSet<License>();
    private Set<Issue> issues = new HashSet<Issue>();
    private Set<Scope> scopes = new HashSet<Scope>();
    private Issue topIssue = new Issue();
    private GeneralInfo generalInfo;

    public DependencyTree() {
    }

    public DependencyTree(Object userObject) {
        super(userObject);
    }

    public void setLicenses(Set<License> licenses) {
        this.licenses = licenses;
    }

    public void setIssues(Set<Issue> issues) {
        this.issues = issues;
    }

    public void setScopes(Set<Scope> scopes) {
        this.scopes = scopes;
    }

    public void setGeneralInfo(GeneralInfo generalInfo) {
        this.generalInfo = generalInfo;
    }

    public Set<License> getLicenses() {
        return this.licenses;
    }

    public Set<Issue> getIssues() {
        return this.issues;
    }

    public Set<Scope> getScopes() {
        return this.scopes;
    }

    public GeneralInfo getGeneralInfo() {
        return this.generalInfo;
    }

    public Issue getTopIssue() {
        return this.topIssue;
    }

    public int getIssueCount() {
        return this.issues.size();
    }

    public Vector<DependencyTree> getChildren() {
        return this.children != null ? this.children : new Vector();
    }

    public Set<Issue> processTreeIssues() {
        this.setIssuesComponent();
        this.getChildren().forEach(child -> this.issues.addAll(child.processTreeIssues()));
        this.setTopIssue();
        this.sortChildren();
        return this.issues;
    }

    private void setIssuesComponent() {
        Object userObject = this.getUserObject();
        if (userObject != null) {
            this.issues.forEach(issue -> issue.setComponent(userObject.toString()));
        }
    }

    private void sortChildren() {
        this.getChildren().sort(Comparator.comparing(DependencyTree::getTopIssue, Comparator.comparing(Issue::getSeverity)).thenComparing(DependencyTree::getIssueCount).thenComparing(DefaultMutableTreeNode::getChildCount).reversed().thenComparing(DefaultMutableTreeNode::toString));
    }

    private void setTopIssue() {
        this.issues.forEach(issue -> {
            if (this.topIssue.isTopSeverity()) {
                return;
            }
            if (issue.isHigherSeverityThan(this.topIssue)) {
                this.topIssue = issue;
            }
        });
    }

    public void collectAllScopesAndLicenses(Set<Scope> allScopes, Set<License> allLicenses) {
        Enumeration<TreeNode> enumeration = this.breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            DependencyTree child = (DependencyTree)enumeration.nextElement();
            allScopes.addAll(child.getScopes());
            allLicenses.addAll(child.getLicenses());
        }
    }
}

