/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.clientConfiguration.client.artifactory.services;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.FileEntity;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.client.ArtifactoryUploadResponse;
import org.jfrog.build.client.ArtifactoryVersion;
import org.jfrog.build.client.JFrogHttpClient;
import org.jfrog.build.extractor.clientConfiguration.client.JFrogService;
import org.jfrog.build.extractor.clientConfiguration.client.artifactory.services.Version;
import org.jfrog.build.extractor.clientConfiguration.deploy.DeployDetails;
import org.jfrog.build.extractor.clientConfiguration.util.DeploymentUrlUtils;

public class Upload
extends JFrogService<ArtifactoryUploadResponse> {
    public static final String SHA1_HEADER_NAME = "X-Checksum-Sha1";
    public static final String MD5_HEADER_NAME = "X-Checksum-Md5";
    public static final String EXPLODE_HEADER_NAME = "X-Explode-Archive";
    public static final String CHECKSUM_DEPLOY_HEADER_NAME = "X-Checksum-Deploy";
    private final DeployDetails details;
    private final String logPrefix;
    private final Integer minChecksumDeploySizeKb;
    private boolean isExplode;

    public Upload(DeployDetails details, String logPrefix, Integer minChecksumDeploySizeKb, Log logger) {
        super(logger);
        this.minChecksumDeploySizeKb = minChecksumDeploySizeKb;
        this.details = details;
        this.logPrefix = logPrefix == null ? "" : logPrefix + " ";
    }

    @Override
    public HttpRequestBase createRequest() throws IOException {
        HttpPut request = this.createHttpPutMethod(this.details);
        request.addHeader("Expect", "100-continue");
        if (this.details.isExplode()) {
            this.isExplode = true;
            request.addHeader(EXPLODE_HEADER_NAME, "true");
        }
        FileEntity fileEntity = new FileEntity(this.details.getFile(), "binary/octet-stream");
        request.setEntity((HttpEntity)fileEntity);
        return request;
    }

    @Override
    protected void handleUnsuccessfulResponse(HttpEntity entity) throws IOException {
        this.log.error("Failed to upload file");
        Upload.throwException(entity, this.getStatusCode());
    }

    @Override
    protected void setResponse(InputStream stream) throws IOException {
        if (!this.isExplode) {
            this.result = this.getMapper().readValue(stream, ArtifactoryUploadResponse.class);
        }
    }

    @Override
    public ArtifactoryUploadResponse execute(JFrogHttpClient client) throws IOException {
        this.log.info(this.logPrefix + "Deploying artifact: " + client.getUrl() + "/" + StringUtils.removeStart((String)this.buildDefaultUploadPath(this.details), (String)"/"));
        ArtifactoryUploadResponse response = this.tryChecksumUpload(client);
        if (response != null) {
            return response;
        }
        return (ArtifactoryUploadResponse)super.execute(client);
    }

    private ArtifactoryUploadResponse tryChecksumUpload(JFrogHttpClient client) {
        try {
            TryChecksumUpload tryChecksumUploadService = new TryChecksumUpload(this.details, this.logPrefix, this.minChecksumDeploySizeKb, this.log);
            return (ArtifactoryUploadResponse)tryChecksumUploadService.execute(client);
        }
        catch (IOException e) {
            this.log.debug("Failed artifact checksum deploy of file " + this.details.getArtifactPath() + " : " + this.details.getSha1());
            return null;
        }
    }

    private HttpPut createHttpPutMethod(DeployDetails details) throws IOException {
        StringBuilder deploymentPathBuilder = new StringBuilder().append(this.buildDefaultUploadPath(details));
        deploymentPathBuilder.append(DeploymentUrlUtils.buildMatrixParamsString(details.getProperties(), true));
        HttpPut httpPut = new HttpPut(deploymentPathBuilder.toString());
        httpPut.addHeader(SHA1_HEADER_NAME, details.getSha1());
        httpPut.addHeader(MD5_HEADER_NAME, details.getMd5());
        this.log.debug("Full Artifact Http path: " + httpPut + "\n@Http Headers: " + Arrays.toString(httpPut.getAllHeaders()));
        return httpPut;
    }

    private String buildDefaultUploadPath(DeployDetails details) {
        ArrayList<String> pathComponents = new ArrayList<String>();
        pathComponents.add(DeploymentUrlUtils.encodePath(details.getTargetRepository()));
        pathComponents.add(DeploymentUrlUtils.encodePath(details.getArtifactPath()));
        return StringUtils.join(pathComponents, (String)"/");
    }

    private class TryChecksumUpload
    extends JFrogService<ArtifactoryUploadResponse> {
        private final DeployDetails details;
        private final String logPrefix;
        private final Integer minChecksumDeploySizeKb;

        private TryChecksumUpload(DeployDetails details, String logPrefix, Integer minChecksumDeploySizeKb, Log logger) {
            super(logger);
            this.details = details;
            this.logPrefix = logPrefix;
            this.minChecksumDeploySizeKb = minChecksumDeploySizeKb != null ? minChecksumDeploySizeKb : 10;
        }

        @Override
        protected void ensureRequirements(JFrogHttpClient client) throws IOException {
            Version versionService = new Version(this.log);
            ArtifactoryVersion version = (ArtifactoryVersion)versionService.execute(client);
            if (!version.isAtLeast((org.jfrog.build.client.Version)new ArtifactoryVersion("2.5.1"))) {
                throw new IOException("Artifactory below 2.5.0 doesnt have efficient checksum deployment");
            }
        }

        @Override
        public HttpRequestBase createRequest() throws IOException {
            long fileLength = this.details.getFile().length();
            if (fileLength < (long)(this.minChecksumDeploySizeKb * 1024)) {
                this.log.debug("Skipping checksum deploy of file size " + fileLength + " bytes, falling back to regular deployment.");
                throw new IOException();
            }
            if (this.details.isExplode()) {
                this.log.debug("Skipping checksum deploy due to explode file request.");
                throw new IOException();
            }
            HttpPut request = Upload.this.createHttpPutMethod(this.details);
            request.addHeader(Upload.CHECKSUM_DEPLOY_HEADER_NAME, "true");
            return request;
        }

        @Override
        protected void setResponse(InputStream stream) throws IOException {
            this.result = this.getMapper().readValue(stream, ArtifactoryUploadResponse.class);
        }
    }
}

