/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.clientConfiguration.client.artifactory.services;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.jfrog.build.api.release.Distribution;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.client.JFrogHttpClient;
import org.jfrog.build.extractor.clientConfiguration.client.VoidJFrogService;
import org.jfrog.build.extractor.clientConfiguration.util.JsonUtils;

public class DistributeBuild
extends VoidJFrogService {
    private static final String BUILD_REST_URL = "api/build";
    private final String buildName;
    private final String buildNumber;
    private final Distribution promotion;

    public DistributeBuild(String buildName, String buildNumber, Distribution promotion, Log log) {
        super(log);
        this.buildName = buildName;
        this.buildNumber = buildNumber;
        this.promotion = promotion;
    }

    @Override
    public HttpRequestBase createRequest() throws IOException {
        String urlBuilder = "api/build/distribute/" + DistributeBuild.encodeUrl(this.buildName) + "/" + DistributeBuild.encodeUrl(this.buildNumber);
        HttpPost request = new HttpPost(urlBuilder);
        StringEntity stringEntity = new StringEntity(JsonUtils.toJsonString(this.promotion));
        stringEntity.setContentType("application/json");
        request.setEntity((HttpEntity)stringEntity);
        this.log.info("Distributing build " + this.buildName + ", #" + this.buildNumber);
        return request;
    }

    @Override
    protected void setResponse(InputStream stream) throws IOException {
        this.log.info(String.format("Successfully distributed build %s/%s", this.buildName, this.buildNumber));
    }

    @Override
    protected void ensureRequirements(JFrogHttpClient client) {
        if (StringUtils.isBlank((String)this.buildName)) {
            throw new IllegalArgumentException("Build name is required for distribution.");
        }
        if (StringUtils.isBlank((String)this.buildNumber)) {
            throw new IllegalArgumentException("Build number is required for distribution.");
        }
    }

    @Override
    protected void handleUnsuccessfulResponse(HttpEntity entity) throws IOException {
        this.log.error("Distribution failed.");
        DistributeBuild.throwException(entity, this.getStatusCode());
    }
}

