/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.clientConfiguration.util.spec.validator;

import java.io.IOException;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.extractor.clientConfiguration.util.spec.FileSpec;
import org.jfrog.build.extractor.clientConfiguration.util.spec.Spec;
import org.jfrog.build.extractor.clientConfiguration.util.spec.validator.SpecsValidator;

public class UploadSpecValidator
extends SpecsValidator {
    @Override
    public void validate(Spec spec, Log log) throws IOException {
        if (ArrayUtils.isEmpty((Object[])spec.getFiles())) {
            throw new IllegalArgumentException("Spec must contain at least one fileSpec.");
        }
        for (FileSpec fileSpec : spec.getFiles()) {
            boolean isExcludePatterns;
            boolean isAql = StringUtils.isNotBlank((String)fileSpec.getAql());
            boolean isPattern = StringUtils.isNotBlank((String)fileSpec.getPattern());
            boolean bl = isExcludePatterns = !ArrayUtils.isEmpty((Object[])fileSpec.getExcludePatterns());
            if (!isAql && !isPattern) {
                throw new IllegalArgumentException("Upload Spec must contain AQL or Pattern key");
            }
            if (StringUtils.isBlank((String)fileSpec.getTarget())) {
                throw new IllegalArgumentException("The argument 'target' is missing from the upload spec.");
            }
            if (StringUtils.isBlank((String)fileSpec.getPattern())) {
                throw new IllegalArgumentException("The argument 'pattern' is missing from the upload spec.");
            }
            UploadSpecValidator.validateQueryInputs(fileSpec);
            if (!isExcludePatterns) continue;
            log.warn("The 'excludePatterns' File Spec property is deprecated.\nPlease use the 'exclusions' File Spec property instead.");
        }
    }
}

