/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.clientConfiguration.client.artifactory.services;

import java.io.IOException;
import java.io.InputStream;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.jfrog.build.api.dependency.PatternResultFileSet;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.extractor.clientConfiguration.client.JFrogService;

public class SearchArtifactsByPattern
extends JFrogService<PatternResultFileSet> {
    private static final String SEARCH_ARTIFACT_BY_PATTERN_ENDPOINT = "api/search/pattern?pattern=";
    private final String pattern;

    public SearchArtifactsByPattern(String pattern, Log log) {
        super(log);
        this.pattern = pattern;
    }

    @Override
    public HttpRequestBase createRequest() throws IOException {
        return new HttpGet(SEARCH_ARTIFACT_BY_PATTERN_ENDPOINT + this.pattern);
    }

    @Override
    protected void handleUnsuccessfulResponse(HttpEntity entity) throws IOException {
        this.log.error("Failed to search artifact by the pattern '" + this.pattern + "'");
        SearchArtifactsByPattern.throwException(entity, this.getStatusCode());
    }

    @Override
    protected void setResponse(InputStream stream) throws IOException {
        this.result = this.getMapper(false).readValue(stream, PatternResultFileSet.class);
    }
}

