/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.clientConfiguration.client.artifactory.services;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.extractor.clientConfiguration.client.JFrogService;
import org.jfrog.build.extractor.clientConfiguration.client.RepositoryType;
import org.jfrog.build.extractor.clientConfiguration.client.response.GetRepositoriesResponse;

public class GetRepositoriesKeys
extends JFrogService<List<String>> {
    private static final String REPOS_REST_URL = "api/repositories?type=";
    protected final Log log;
    RepositoryType repositoryType;

    public GetRepositoriesKeys(RepositoryType repositoryType, Log logger) {
        super(logger);
        this.result = new ArrayList();
        this.repositoryType = repositoryType;
        this.log = logger;
    }

    @Override
    public HttpRequestBase createRequest() {
        String endpoint = REPOS_REST_URL + this.repositoryType.name().toLowerCase();
        HttpGet req = new HttpGet(endpoint);
        this.log.debug("Requesting repositories list from: " + endpoint);
        return req;
    }

    @Override
    protected void setResponse(InputStream stream) throws IOException {
        List keys = (List)this.getMapper(true).readValue(stream, (JavaType)TypeFactory.defaultInstance().constructCollectionLikeType(List.class, GetRepositoriesResponse.class));
        this.result = keys.stream().map(GetRepositoriesResponse::getKey).collect(Collectors.toList());
    }

    @Override
    protected void handleUnsuccessfulResponse(HttpEntity entity) throws IOException {
        this.log.error("Failed to obtain list of repositories.");
        GetRepositoriesKeys.throwException(entity, this.getStatusCode());
    }
}

