/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.jfrog.build.extractor.clientConfiguration.client.artifactory.ArtifactoryManager;
import org.jfrog.build.extractor.clientConfiguration.deploy.DeployDetails;

public class ModuleParallelDeployHelper {
    public static final int DEFAULT_DEPLOYMENT_THREADS = 3;

    public void deployArtifacts(ArtifactoryManager artifactoryManager, Map<String, Set<DeployDetails>> deployableArtifactsByModule, int publishForkCount) {
        if (publishForkCount <= 1) {
            deployableArtifactsByModule.forEach((module, deployableArtifacts) -> this.deploy(artifactoryManager, (Set<DeployDetails>)deployableArtifacts, null));
        } else {
            try {
                ExecutorService executor = Executors.newFixedThreadPool(publishForkCount);
                CompletableFuture<Void> allDeployments = CompletableFuture.allOf((CompletableFuture[])deployableArtifactsByModule.values().stream().map(deployDetails -> CompletableFuture.runAsync(() -> this.deploy(artifactoryManager, (Set<DeployDetails>)deployDetails, "[" + Thread.currentThread().getName() + "]"), executor)).toArray(CompletableFuture[]::new));
                allDeployments.get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void deploy(ArtifactoryManager artifactoryManager, Set<DeployDetails> deployableArtifacts, String logPrefix) {
        deployableArtifacts.forEach(artifact -> {
            try {
                artifactoryManager.upload((DeployDetails)artifact, logPrefix);
            }
            catch (IOException e) {
                throw new RuntimeException("Error occurred while publishing artifact to Artifactory: " + artifact.getFile() + ".\n Skipping deployment of remaining artifacts (if any) and build info.", e);
            }
        });
    }
}

