/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.docker.extractor;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.extractor.ci.BuildInfo;
import org.jfrog.build.extractor.ci.Module;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryClientConfiguration;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryManagerBuilder;
import org.jfrog.build.extractor.docker.DockerJavaWrapper;
import org.jfrog.build.extractor.docker.DockerUtils;
import org.jfrog.build.extractor.docker.extractor.DockerCommand;
import org.jfrog.build.extractor.docker.types.DockerImage;
import org.jfrog.build.extractor.packageManager.PackageManagerUtils;

public class DockerPull
extends DockerCommand {
    public DockerPull(ArtifactoryManagerBuilder artifactoryManagerBuilder, String imageTag, String host, String targetRepository, String username, String password, Log logger, Map<String, String> env) {
        super(artifactoryManagerBuilder, imageTag, host, targetRepository, username, password, logger, env);
    }

    public static void main(String[] ignored) {
        try {
            ArtifactoryClientConfiguration clientConfiguration = PackageManagerUtils.createArtifactoryClientConfiguration();
            ArtifactoryManagerBuilder artifactoryManagerBuilder = (ArtifactoryManagerBuilder)new ArtifactoryManagerBuilder().setClientConfiguration(clientConfiguration, (ArtifactoryClientConfiguration.RepositoryConfiguration)clientConfiguration.resolver);
            ArtifactoryClientConfiguration.DockerHandler dockerHandler = clientConfiguration.dockerHandler;
            DockerPull dockerPush = new DockerPull(artifactoryManagerBuilder, dockerHandler.getImageTag(), dockerHandler.getHost(), clientConfiguration.resolver.getRepoKey(), clientConfiguration.resolver.getUsername(), clientConfiguration.resolver.getPassword(), clientConfiguration.getLog(), clientConfiguration.getAllProperties());
            dockerPush.executeAndSaveBuildInfo(clientConfiguration);
        }
        catch (RuntimeException e) {
            ExceptionUtils.printRootCauseStackTrace((Throwable)e, (PrintStream)System.out);
            System.exit(1);
        }
    }

    public BuildInfo execute() {
        String message = "Pulling image: " + this.imageTag;
        if (StringUtils.isNotEmpty((CharSequence)this.host)) {
            message = message + " using docker daemon host: " + this.host;
        }
        this.logger.info(message);
        try {
            DockerJavaWrapper.pullImage(this.imageTag, this.username, this.password, this.host, this.env, this.logger);
            String imageId = DockerJavaWrapper.getImageIdFromTag(this.imageTag, this.host, this.env, this.logger);
            Pair<String, String> archDetails = DockerJavaWrapper.getImageArch(this.imageTag, this.host, this.env, this.logger);
            DockerImage image = new DockerImage(imageId, this.imageTag, "", this.targetRepository, this.artifactoryManagerBuilder, (String)archDetails.getLeft(), (String)archDetails.getRight());
            Module module = image.generateBuildInfoModule(this.logger, DockerUtils.CommandType.Pull);
            if (module.getDependencies() == null || module.getDependencies().size() == 0) {
                this.logger.warn("Could not find docker image: " + this.imageTag + " in Artifactory.");
            }
            BuildInfo buildInfo = new BuildInfo();
            this.modulesList.add(module);
            buildInfo.setModules(this.modulesList);
            this.logger.info("Successfully pulled docker image: " + this.imageTag);
            return buildInfo;
        }
        catch (IOException | InterruptedException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

