/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.docker;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.BuildImageCmd;
import com.github.dockerjava.api.command.DockerCmdExecFactory;
import com.github.dockerjava.api.command.InspectImageResponse;
import com.github.dockerjava.api.model.AuthConfig;
import com.github.dockerjava.core.DefaultDockerClientConfig;
import com.github.dockerjava.core.DockerClientBuilder;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.core.command.BuildImageResultCallback;
import com.github.dockerjava.core.command.PullImageResultCallback;
import com.github.dockerjava.core.command.PushImageResultCallback;
import com.github.dockerjava.netty.NettyDockerCmdExecFactory;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.jfrog.build.api.util.Log;

public class DockerJavaWrapper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pushImage(String imageTag, String username, String password, String host, Map<String, String> envVars, Log logger) throws InterruptedException {
        AuthConfig authConfig = new AuthConfig();
        authConfig.withUsername(username);
        authConfig.withPassword(password);
        DockerClient dockerClient = null;
        try {
            dockerClient = DockerJavaWrapper.getDockerClient(host, envVars);
            ((PushImageResultCallback)dockerClient.pushImageCmd(imageTag).withAuthConfig(authConfig).exec((ResultCallback)new PushImageResultCallback())).awaitCompletion();
        }
        finally {
            DockerJavaWrapper.closeQuietly(dockerClient, logger);
        }
    }

    public static DockerClient getDockerClient(String host, Map<String, String> envVars) {
        if (envVars == null) {
            throw new IllegalStateException("envVars must not be null");
        }
        DefaultDockerClientConfig.Builder configBuilder = DefaultDockerClientConfig.createDefaultConfigBuilder();
        if (envVars.containsKey("DOCKER_HOST")) {
            configBuilder.withDockerHost(envVars.get("DOCKER_HOST"));
        } else if (StringUtils.isNotBlank((CharSequence)host) && !host.equalsIgnoreCase("null")) {
            configBuilder.withDockerHost(host);
        }
        if (envVars.containsKey("DOCKER_TLS_VERIFY")) {
            configBuilder.withDockerTlsVerify(envVars.get("DOCKER_TLS_VERIFY"));
        }
        if (envVars.containsKey("DOCKER_CERT_PATH")) {
            configBuilder.withDockerCertPath(envVars.get("DOCKER_CERT_PATH"));
        }
        DefaultDockerClientConfig config = configBuilder.build();
        return DockerClientBuilder.getInstance((DockerClientConfig)config).withDockerCmdExecFactory((DockerCmdExecFactory)new NettyDockerCmdExecFactory()).build();
    }

    public static String getImageIdFromTag(String imageTag, String host, Map<String, String> envVars, Log logger) {
        return DockerJavaWrapper.InspectImage(imageTag, host, envVars, logger).getId();
    }

    public static Pair<String, String> getImageArch(String imageTag, String host, Map<String, String> envVars, Log logger) {
        InspectImageResponse response = DockerJavaWrapper.InspectImage(imageTag, host, envVars, logger);
        String imageArch = response.getArch();
        String imageOs = response.getOs();
        return Pair.of((Object)imageArch, (Object)imageOs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InspectImageResponse InspectImage(String imageTag, String host, Map<String, String> envVars, Log logger) {
        DockerClient dockerClient = null;
        try {
            dockerClient = DockerJavaWrapper.getDockerClient(host, envVars);
            InspectImageResponse inspectImageResponse = dockerClient.inspectImageCmd(imageTag).exec();
            return inspectImageResponse;
        }
        finally {
            DockerJavaWrapper.closeQuietly(dockerClient, logger);
        }
    }

    private static void closeQuietly(DockerClient dockerClient, Log logger) {
        if (dockerClient != null) {
            try {
                dockerClient.close();
            }
            catch (IOException e) {
                logger.error("Closes docker client failed.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pullImage(String imageTag, String username, String password, String host, Map<String, String> envVars, Log logger) throws InterruptedException {
        AuthConfig authConfig = new AuthConfig();
        authConfig.withUsername(username);
        authConfig.withPassword(password);
        DockerClient dockerClient = null;
        try {
            dockerClient = DockerJavaWrapper.getDockerClient(host, envVars);
            ((PullImageResultCallback)dockerClient.pullImageCmd(imageTag).withAuthConfig(authConfig).exec((ResultCallback)new PullImageResultCallback())).awaitCompletion();
        }
        finally {
            DockerJavaWrapper.closeQuietly(dockerClient, logger);
        }
    }

    public static void buildImage(String imageName, String host, Map<String, String> envVars, String projectPath) {
        DockerClient dockerClient = DockerJavaWrapper.getDockerClient(host, envVars);
        BuildImageCmd buildImageCmd = dockerClient.buildImageCmd(Paths.get(projectPath, new String[0]).toFile()).withTags(new HashSet<String>(Collections.singletonList(imageName)));
        ((BuildImageResultCallback)buildImageCmd.exec((ResultCallback)new BuildImageResultCallback())).awaitImageId();
    }
}

