/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.docker.extractor;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jfrog.build.api.Build;
import org.jfrog.build.api.Module;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryClientConfiguration;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryManagerBuilder;
import org.jfrog.build.extractor.clientConfiguration.client.artifactory.ArtifactoryManager;
import org.jfrog.build.extractor.docker.DockerUtils;
import org.jfrog.build.extractor.docker.types.DockerImage;
import org.jfrog.build.extractor.docker.types.DockerLayer;
import org.jfrog.build.extractor.docker.types.DockerLayers;
import org.jfrog.build.extractor.packageManager.PackageManagerExtractor;
import org.jfrog.build.extractor.packageManager.PackageManagerUtils;

public class BuildDockerCreate
extends PackageManagerExtractor {
    private final ArtifactoryManagerBuilder artifactoryManagerBuilder;
    private final Log logger;
    private final String kanikoImageFile;
    private final String targetRepository;
    private final List<Module> modulesList = new ArrayList<Module>();
    private final ArrayListMultimap<String, String> artifactProperties;

    public BuildDockerCreate(ArtifactoryManagerBuilder artifactoryManagerBuilder, String kanikoImageFile, ArrayListMultimap<String, String> artifactProperties, String targetRepository, Log logger) {
        this.artifactoryManagerBuilder = artifactoryManagerBuilder;
        this.targetRepository = targetRepository;
        this.logger = logger;
        this.kanikoImageFile = kanikoImageFile;
        this.artifactProperties = artifactProperties;
    }

    public static void main(String[] ignored) {
        try {
            ArtifactoryClientConfiguration clientConfiguration = PackageManagerUtils.createArtifactoryClientConfiguration();
            ArtifactoryManagerBuilder artifactoryManagerBuilder = (ArtifactoryManagerBuilder)new ArtifactoryManagerBuilder().setClientConfiguration(clientConfiguration, (ArtifactoryClientConfiguration.RepositoryConfiguration)clientConfiguration.publisher);
            ArtifactoryClientConfiguration.KanikoHandler kanikoHandler = clientConfiguration.kanikoHandler;
            BuildDockerCreate dockerBuildCreate = new BuildDockerCreate(artifactoryManagerBuilder, kanikoHandler.getImageFile(), (ArrayListMultimap<String, String>)ArrayListMultimap.create((Multimap)clientConfiguration.publisher.getMatrixParams().asMultimap()), clientConfiguration.publisher.getRepoKey(), clientConfiguration.getLog());
            dockerBuildCreate.executeAndSaveBuildInfo(clientConfiguration);
        }
        catch (RuntimeException e) {
            ExceptionUtils.printRootCauseStackTrace((Throwable)e, (PrintStream)System.out);
            System.exit(1);
        }
    }

    public Build execute() {
        this.logger.info("Getting build info for: " + this.kanikoImageFile);
        try {
            Build build = new Build();
            for (ImageFileWithDigest imageFileWithDigest : this.getImageFileWithDigests(this.kanikoImageFile)) {
                DockerImage image = new DockerImage(imageFileWithDigest.manifestSha256, imageFileWithDigest.imageName, this.targetRepository, this.artifactoryManagerBuilder, "", "");
                Module module = image.generateBuildInfoModule(this.logger, DockerUtils.CommandType.Push);
                if (module.getArtifacts() == null || module.getArtifacts().size() == 0) {
                    this.logger.warn("Could not find docker image: " + imageFileWithDigest.imageName + " in Artifactory.");
                } else {
                    this.setImageLayersProps(image.getLayers(), this.artifactProperties, this.artifactoryManagerBuilder);
                }
                this.modulesList.add(module);
                this.logger.info("Successfully created build info for image: " + imageFileWithDigest.imageName);
            }
            build.setModules(this.modulesList);
            return build;
        }
        catch (IOException | InterruptedException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (RuntimeException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    private void setImageLayersProps(DockerLayers layers, ArrayListMultimap<String, String> artifactProperties, ArtifactoryManagerBuilder artifactoryManagerBuilder) throws IOException {
        if (layers == null) {
            return;
        }
        try (ArtifactoryManager artifactoryManager = artifactoryManagerBuilder.build();){
            for (DockerLayer layer : layers.getLayers()) {
                artifactoryManager.setProperties(layer.getFullPath(), artifactProperties, false);
            }
        }
    }

    private List<ImageFileWithDigest> getImageFileWithDigests(String filePath) throws IOException {
        List<String> dataLines = Files.readAllLines(Paths.get(filePath, new String[0]));
        if (dataLines.isEmpty()) {
            throw new IOException("empty image file \"" + filePath + "\".");
        }
        List<ImageFileWithDigest> imageFileWithDigests = dataLines.stream().map(this::getImageFileWithDigest).filter(Objects::nonNull).collect(Collectors.toList());
        if (imageFileWithDigests.size() != dataLines.size()) {
            throw new RuntimeException("missing image-tag/sha256 in file: \"" + filePath + "\"");
        }
        return imageFileWithDigests;
    }

    private ImageFileWithDigest getImageFileWithDigest(String data) {
        String[] splittedData = data.split("@");
        if (splittedData.length != 2) {
            throw new RuntimeException("unexpected file format \"" + data + "\". The file should include one line in the following format: image-tag@sha256");
        }
        ImageFileWithDigest imageFileWithDigest = new ImageFileWithDigest(splittedData[0], splittedData[1]);
        if (imageFileWithDigest.imageName.isEmpty() || imageFileWithDigest.manifestSha256.isEmpty()) {
            return null;
        }
        return imageFileWithDigest;
    }

    private static class ImageFileWithDigest {
        final String imageName;
        final String manifestSha256;

        ImageFileWithDigest(String imageName, String manifestSha256) {
            this.imageName = imageName.trim();
            this.manifestSha256 = manifestSha256.trim();
        }
    }
}

