/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.docker.types;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.util.EntityUtils;
import org.jfrog.build.api.Artifact;
import org.jfrog.build.api.Dependency;
import org.jfrog.build.api.Module;
import org.jfrog.build.api.builder.ArtifactBuilder;
import org.jfrog.build.api.builder.DependencyBuilder;
import org.jfrog.build.api.builder.ModuleBuilder;
import org.jfrog.build.api.builder.ModuleType;
import org.jfrog.build.api.search.AqlSearchResult;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.client.ArtifactoryVersion;
import org.jfrog.build.client.Version;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryBuildInfoClientBuilder;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryDependenciesClientBuilder;
import org.jfrog.build.extractor.clientConfiguration.client.ArtifactoryBuildInfoClient;
import org.jfrog.build.extractor.clientConfiguration.client.ArtifactoryDependenciesClient;
import org.jfrog.build.extractor.docker.DockerUtils;
import org.jfrog.build.extractor.docker.types.DockerLayer;
import org.jfrog.build.extractor.docker.types.DockerLayers;

public class DockerImage
implements Serializable {
    private final String imageId;
    private final String imageTag;
    private final String targetRepo;
    private final ArtifactoryVersion VIRTUAL_REPOS_SUPPORTED_VERSION = new ArtifactoryVersion("4.8.1");
    private final Properties buildInfoModuleProps = new Properties();
    private final String os;
    private final String architecture;
    private final ArtifactoryBuildInfoClientBuilder buildInfoClientBuilder;
    private final ArtifactoryDependenciesClientBuilder dependenciesClientBuilder;
    private String manifest;
    private String imagePath;
    private DockerLayers layers;

    public DockerImage(String imageId, String imageTag, String targetRepo, ArtifactoryBuildInfoClientBuilder buildInfoClientBuilder, ArtifactoryDependenciesClientBuilder dependenciesClientBuilder, String arch, String os) {
        this.imageId = imageId;
        this.imageTag = imageTag;
        this.targetRepo = targetRepo;
        this.buildInfoClientBuilder = buildInfoClientBuilder;
        this.dependenciesClientBuilder = dependenciesClientBuilder;
        this.architecture = arch;
        this.os = os;
    }

    public DockerLayers getLayers() {
        return this.layers;
    }

    private void checkAndSetManifestAndImagePathCandidates(String candidateManifestPath, ArtifactoryDependenciesClient dependenciesClient, Log logger) throws IOException {
        Pair<String, String> candidateDetails = this.getManifestFromArtifactory(dependenciesClient, candidateManifestPath, logger);
        String manifestContent = (String)candidateDetails.getLeft();
        String manifestPath = (String)candidateDetails.getRight();
        String imageDigest = DockerUtils.getConfigDigest(manifestContent);
        if (imageDigest.equals(this.imageId)) {
            this.manifest = manifestContent;
            this.imagePath = manifestPath;
            this.loadLayers(manifestPath);
        }
    }

    /*
     * Exception decompiling
     */
    private Pair<String, String> getManifestFromArtifactory(ArtifactoryDependenciesClient dependenciesClient, String manifestPath, Log logger) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void setBuildInfoModuleProps(ModuleBuilder moduleBuilder) {
        this.buildInfoModuleProps.setProperty("docker.image.id", DockerUtils.getShaValue(this.imageId));
        this.buildInfoModuleProps.setProperty("docker.captured.image", this.imageTag);
        moduleBuilder.properties(this.buildInfoModuleProps);
    }

    private DockerLayers createLayers(ArtifactoryDependenciesClient dependenciesClient, String aql) throws IOException {
        AqlSearchResult result = dependenciesClient.searchArtifactsByAql(aql);
        DockerLayers layers = new DockerLayers();
        for (AqlSearchResult.SearchEntry entry : result.getResults()) {
            DockerLayer layer = new DockerLayer(entry);
            layers.addLayer(layer);
        }
        if (layers.getLayers().size() == 0) {
            throw new IllegalStateException(String.format("No docker layers found in Artifactory using AQL: %s after filtering layers in repos other than %s and with path other than %s", aql, this.targetRepo, this.imagePath));
        }
        return layers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDependenciesAndArtifacts(ModuleBuilder moduleBuilder, ArtifactoryDependenciesClient dependenciesClient) throws IOException {
        DockerLayer historyLayer = this.layers.getByDigest(this.imageId);
        if (historyLayer == null) {
            throw new IllegalStateException("Could not find the history docker layer: " + this.imageId + " for image: " + this.imageTag + " in Artifactory.");
        }
        HttpEntity entity = null;
        try (CloseableHttpResponse res = dependenciesClient.downloadArtifact(dependenciesClient.getArtifactoryUrl() + "/" + historyLayer.getFullPath());){
            entity = res.getEntity();
            int dependencyLayerNum = DockerUtils.getNumberOfDependentLayers(DockerUtils.entityToString(res.getEntity()));
            LinkedHashSet<Dependency> dependencies = new LinkedHashSet<Dependency>();
            LinkedHashSet<Artifact> artifacts = new LinkedHashSet<Artifact>();
            Iterator<String> it = DockerUtils.getLayersDigests(this.manifest).iterator();
            for (int i = 0; i < dependencyLayerNum; ++i) {
                String digest = it.next();
                DockerLayer layer = this.layers.getByDigest(digest);
                Dependency dependency = new DependencyBuilder().id(layer.getFileName()).sha1(layer.getSha1()).build();
                dependencies.add(dependency);
                Artifact artifact = new ArtifactBuilder(layer.getFileName()).sha1(layer.getSha1()).remotePath(layer.getPath()).build();
                artifacts.add(artifact);
            }
            moduleBuilder.dependencies(new ArrayList(dependencies));
            while (it.hasNext()) {
                String digest = it.next();
                DockerLayer layer = this.layers.getByDigest(digest);
                if (layer == null) continue;
                Artifact artifact = new ArtifactBuilder(layer.getFileName()).sha1(layer.getSha1()).remotePath(layer.getPath()).build();
                artifacts.add(artifact);
            }
            moduleBuilder.artifacts(new ArrayList(artifacts));
        }
        catch (Throwable throwable) {
            EntityUtils.consume(entity);
            throw throwable;
        }
        EntityUtils.consume((HttpEntity)entity);
    }

    private void setDependencies(ModuleBuilder moduleBuilder) throws IOException {
        LinkedHashSet<Dependency> dependencies = new LinkedHashSet<Dependency>();
        for (String digest : DockerUtils.getLayersDigests(this.manifest)) {
            DockerLayer layer = this.layers.getByDigest(digest);
            Dependency dependency = new DependencyBuilder().id(layer.getFileName()).sha1(layer.getSha1()).build();
            dependencies.add(dependency);
        }
        moduleBuilder.dependencies(new ArrayList(dependencies));
    }

    private String getAqlQuery(boolean includeVirtualRepos, String Repo, String manifestPath) {
        StringBuilder aqlRequestForDockerSha = new StringBuilder("items.find({").append("\"path\":\"").append(manifestPath).append("\",").append("\"repo\":\"").append(Repo).append("\"})");
        if (includeVirtualRepos) {
            aqlRequestForDockerSha.append(".include(\"name\",\"repo\",\"path\",\"actual_sha1\",\"virtual_repos\")");
        } else {
            aqlRequestForDockerSha.append(".include(\"name\",\"repo\",\"path\",\"actual_sha1\")");
        }
        return aqlRequestForDockerSha.toString();
    }

    public Module generateBuildInfoModule(Log logger, DockerUtils.CommandType cmdType) throws IOException {
        try (ArtifactoryDependenciesClient dependenciesClient = this.dependenciesClientBuilder.build();){
            ModuleBuilder moduleBuilder = new ModuleBuilder().type(ModuleType.DOCKER).id(this.imageTag.substring(this.imageTag.indexOf("/") + 1)).repository(this.targetRepo);
            try {
                this.findAndSetManifestFromArtifactory(dependenciesClient, logger, cmdType);
            }
            catch (IOException e) {
                logger.error("The manifest could not be fetched from Artifactory.");
                Module module = moduleBuilder.build();
                if (dependenciesClient != null) {
                    if (var4_4 != null) {
                        try {
                            dependenciesClient.close();
                        }
                        catch (Throwable throwable) {
                            var4_4.addSuppressed(throwable);
                        }
                    } else {
                        dependenciesClient.close();
                    }
                }
                return module;
            }
            logger.info("Fetching details of published docker layers from Artifactory...");
            if (cmdType == DockerUtils.CommandType.Push) {
                this.setDependenciesAndArtifacts(moduleBuilder, dependenciesClient);
            } else {
                this.setDependencies(moduleBuilder);
            }
            this.setBuildInfoModuleProps(moduleBuilder);
            Module module = moduleBuilder.build();
            return module;
        }
    }

    private void loadLayers(String manifestPath) throws IOException {
        try (ArtifactoryBuildInfoClient buildInfoClient = this.buildInfoClientBuilder.build();
             ArtifactoryDependenciesClient dependenciesClient = this.dependenciesClientBuilder.build();){
            this.layers = this.getLayers(dependenciesClient, buildInfoClient, manifestPath);
            List markerLayers = this.layers.getLayers().stream().filter(layer -> layer.getFileName().endsWith(".marker")).collect(Collectors.toList());
            if (markerLayers.size() > 0) {
                for (DockerLayer markerLayer : markerLayers) {
                    String imageDigests = StringUtils.removeEnd((String)markerLayer.getDigest(), (String)".marker");
                    String imageName = StringUtils.substringBetween((String)this.imageTag, (String)"/", (String)":");
                    DockerUtils.downloadMarkerLayer(this.targetRepo, imageName, imageDigests, dependenciesClient);
                }
                this.layers = this.getLayers(dependenciesClient, buildInfoClient, manifestPath);
            }
        }
    }

    private DockerLayers getLayers(ArtifactoryDependenciesClient dependenciesClient, ArtifactoryBuildInfoClient buildInfoClient, String manifestPath) throws IOException {
        String searchableRepo = this.targetRepo;
        if (dependenciesClient.isRemoteRepo(this.targetRepo)) {
            searchableRepo = searchableRepo + "-cache";
        }
        String aql = this.getAqlQuery(buildInfoClient.getArtifactoryVersion().isAtLeast((Version)this.VIRTUAL_REPOS_SUPPORTED_VERSION), searchableRepo, manifestPath);
        return this.createLayers(dependenciesClient, aql);
    }

    private void findAndSetManifestFromArtifactory(ArtifactoryDependenciesClient dependenciesClient, Log logger, DockerUtils.CommandType cmdType) throws IOException {
        String ImagePath = DockerUtils.getImagePath(this.imageTag);
        ArrayList<String> manifestPathCandidate = new ArrayList<String>(DockerUtils.getArtManifestPath(ImagePath, this.targetRepo, cmdType));
        logger.info("Searching manifest for image \"" + this.imageTag + "\" in \"" + dependenciesClient.getArtifactoryUrl() + "\" under \"" + this.targetRepo + "\" repository");
        int listLen = manifestPathCandidate.size();
        for (int i = 0; i < listLen; ++i) {
            try {
                logger.info("Searching manifest in path: " + manifestPathCandidate.get(i));
                this.checkAndSetManifestAndImagePathCandidates(manifestPathCandidate.get(i), dependenciesClient, logger);
                return;
            }
            catch (IOException e) {
                logger.info("The search failed with \"" + e.getMessage() + "\".");
                if (i != listLen - 1) continue;
                throw e;
            }
        }
    }
}

