/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.client.bintrayResponse;

import com.fasterxml.jackson.core.JsonParser;
import java.io.IOException;
import org.jfrog.build.client.bintrayResponse.BintrayFailure;
import org.jfrog.build.client.bintrayResponse.BintrayResponse;
import org.jfrog.build.client.bintrayResponse.BintraySuccess;
import org.jfrog.build.client.bintrayResponse.EmptyBintrayResponse;

public class BintrayResponseFactory {
    public static BintrayResponse createResponse(int status, JsonParser parser) {
        BintrayResponse response;
        try {
            switch (status) {
                case 200: {
                    response = BintrayResponseFactory.createSuccessResponse(parser);
                    break;
                }
                default: {
                    response = BintrayResponseFactory.createFailedResponse(parser);
                    break;
                }
            }
        }
        catch (IOException e) {
            response = new EmptyBintrayResponse(status);
        }
        return response;
    }

    private static BintrayResponse createSuccessResponse(JsonParser parser) throws IOException {
        BintraySuccess successResponse = (BintraySuccess)parser.readValueAs(BintraySuccess.class);
        return successResponse;
    }

    private static BintrayResponse createFailedResponse(JsonParser parser) throws IOException {
        BintrayFailure failedResponse = (BintrayFailure)parser.readValueAs(BintrayFailure.class);
        return failedResponse;
    }
}

