/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.client;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.io.File;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.jfrog.build.api.BuildFileBean;

public class DeployDetails
implements Comparable<DeployDetails>,
Serializable {
    String artifactPath;
    File file;
    String sha1;
    String md5;
    ArrayListMultimap<String, String> properties;
    private String targetRepository;
    private boolean explode;

    public String getTargetRepository() {
        return this.targetRepository;
    }

    public String getArtifactPath() {
        return this.artifactPath;
    }

    public File getFile() {
        return this.file;
    }

    public ArrayListMultimap<String, String> getProperties() {
        return this.properties;
    }

    public String getSha1() {
        return this.sha1;
    }

    public String getMd5() {
        return this.md5;
    }

    public boolean isExplode() {
        return this.explode;
    }

    @Override
    public int compareTo(DeployDetails that) {
        return this.artifactPath.compareTo(that.artifactPath);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeployDetails details = (DeployDetails)o;
        return this.artifactPath.equals(details.artifactPath);
    }

    public int hashCode() {
        return this.artifactPath.hashCode();
    }

    public static class Builder {
        private DeployDetails deployDetails = new DeployDetails();

        public DeployDetails build() {
            if (this.deployDetails.file == null || !this.deployDetails.file.exists()) {
                throw new IllegalArgumentException("File not found: " + this.deployDetails.file);
            }
            if (StringUtils.isBlank((String)this.deployDetails.targetRepository)) {
                throw new IllegalArgumentException("Target repository cannot be empty");
            }
            if (StringUtils.isBlank((String)this.deployDetails.artifactPath)) {
                throw new IllegalArgumentException("Artifact path cannot be empty");
            }
            return this.deployDetails;
        }

        public Builder bean(BuildFileBean bean) {
            Properties beanProperties = bean.getProperties();
            if (beanProperties != null) {
                ArrayListMultimap multimap = ArrayListMultimap.create();
                for (Map.Entry entry : Maps.fromProperties((Properties)beanProperties).entrySet()) {
                    multimap.put(entry.getKey(), entry.getValue());
                }
                this.deployDetails.properties = multimap;
            }
            this.deployDetails.sha1 = bean.getSha1();
            this.deployDetails.md5 = bean.getMd5();
            return this;
        }

        public Builder file(File file) {
            this.deployDetails.file = file;
            return this;
        }

        public Builder targetRepository(String targetRepository) {
            this.deployDetails.targetRepository = targetRepository;
            return this;
        }

        public Builder artifactPath(String artifactPath) {
            this.deployDetails.artifactPath = artifactPath;
            return this;
        }

        public Builder sha1(String sha1) {
            this.deployDetails.sha1 = sha1;
            return this;
        }

        public Builder md5(String md5) {
            this.deployDetails.md5 = md5;
            return this;
        }

        public Builder explode(boolean isExplodeArchive) {
            this.deployDetails.explode = isExplodeArchive;
            return this;
        }

        public Builder addProperty(String key, String value) {
            if (this.deployDetails.properties == null) {
                this.deployDetails.properties = ArrayListMultimap.create();
            }
            this.deployDetails.properties.put((Object)key, (Object)value);
            return this;
        }

        public Builder addProperties(Map<String, String> propertiesToAdd) {
            if (this.deployDetails.properties == null) {
                this.deployDetails.properties = ArrayListMultimap.create();
            }
            this.deployDetails.properties.putAll((Multimap)Multimaps.forMap(propertiesToAdd));
            return this;
        }

        public Builder addProperties(Multimap<String, String> propertiesToAdd) {
            if (this.deployDetails.properties == null) {
                this.deployDetails.properties = ArrayListMultimap.create();
            }
            this.deployDetails.properties.putAll(propertiesToAdd);
            return this;
        }
    }
}

