/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.client;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.net.ssl.SSLException;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolException;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.AuthState;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.DefaultHttpResponseFactory;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.client.ProxyConfiguration;

public class PreemptiveHttpClient {
    private static final String CLIENT_VERSION;
    private final boolean requestSentRetryEnabled = true;
    private CloseableHttpClient httpClient;
    private BasicHttpContext localContext;
    private ResponseHandler<HttpResponse> responseHandler = new PreemptiveHttpClientHandler();
    private int connectionRetries;
    private int retryCounter;
    private Log log;

    public PreemptiveHttpClient(int timeout) {
        this(null, null, timeout, null, 3);
    }

    public PreemptiveHttpClient(String userName, String password, int timeout) {
        this(userName, password, timeout, null, 3);
    }

    public PreemptiveHttpClient(String userName, String password, int timeout, ProxyConfiguration proxyConfiguration, int connectionRetries) {
        HttpClientBuilder httpClientBuilder = this.createHttpClientBuilder(userName, password, timeout, connectionRetries);
        if (proxyConfiguration != null) {
            this.setProxyConfiguration(httpClientBuilder, proxyConfiguration);
        }
        this.httpClient = httpClientBuilder.build();
    }

    private void setProxyConfiguration(HttpClientBuilder httpClientBuilder, ProxyConfiguration proxyConfiguration) {
        HttpHost proxy = new HttpHost(proxyConfiguration.host, proxyConfiguration.port);
        httpClientBuilder.setProxy(proxy);
        if (proxyConfiguration.username != null) {
            BasicCredentialsProvider basicCredentialsProvider = new BasicCredentialsProvider();
            basicCredentialsProvider.setCredentials(new AuthScope(AuthScope.ANY_HOST, -1), (Credentials)new UsernamePasswordCredentials(proxyConfiguration.username, proxyConfiguration.password));
            httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)basicCredentialsProvider);
        }
    }

    public HttpResponse execute(HttpUriRequest request) throws IOException {
        if (this.localContext != null) {
            return (HttpResponse)this.httpClient.execute(request, this.responseHandler, (HttpContext)this.localContext);
        }
        return (HttpResponse)this.httpClient.execute(request, this.responseHandler);
    }

    private HttpClientBuilder createHttpClientBuilder(String userName, String password, int timeout) {
        return this.createHttpClientBuilder(userName, password, timeout, 3);
    }

    private HttpClientBuilder createHttpClientBuilder(String userName, String password, int timeout, int connectionRetries) {
        this.connectionRetries = connectionRetries;
        int timeoutMilliSeconds = timeout * 1000;
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(timeoutMilliSeconds).setConnectTimeout(timeoutMilliSeconds).setCircularRedirectsAllowed(true).build();
        HttpClientBuilder builder = HttpClientBuilder.create().setDefaultRequestConfig(requestConfig);
        if (userName != null && !"".equals(userName)) {
            BasicCredentialsProvider basicCredentialsProvider = new BasicCredentialsProvider();
            basicCredentialsProvider.setCredentials(new AuthScope(AuthScope.ANY_HOST, -1), (Credentials)new UsernamePasswordCredentials(userName, password));
            builder.setDefaultCredentialsProvider((CredentialsProvider)basicCredentialsProvider);
            this.localContext = new BasicHttpContext();
            BasicScheme basicAuth = new BasicScheme();
            this.localContext.setAttribute("preemptive-auth", (Object)basicAuth);
            builder.addInterceptorFirst((HttpRequestInterceptor)new PreemptiveAuth());
        }
        int retryCount = connectionRetries < 0 ? 3 : connectionRetries;
        builder.setRetryHandler((HttpRequestRetryHandler)new PreemptiveRetryHandler(retryCount));
        builder.setServiceUnavailableRetryStrategy((ServiceUnavailableRetryStrategy)new PreemptiveRetryStrategy());
        builder.setRedirectStrategy((RedirectStrategy)new PreemptiveRedirectStrategy());
        String userAgent = "ArtifactoryBuildClient/" + CLIENT_VERSION;
        builder.setUserAgent(userAgent);
        return builder;
    }

    public void close() {
        try {
            this.httpClient.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setLog(Log log) {
        this.log = log;
    }

    private Set<Class<? extends IOException>> getNonRetriableClasses() {
        HashSet<Class<? extends IOException>> classSet = new HashSet<Class<? extends IOException>>();
        classSet.add(SSLException.class);
        return classSet;
    }

    static {
        Properties properties = new Properties();
        InputStream is = PreemptiveHttpClient.class.getResourceAsStream("/bi.client.properties");
        if (is != null) {
            try {
                properties.load(is);
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        CLIENT_VERSION = properties.getProperty("client.version", "unknown");
    }

    private class PreemptiveHttpClientHandler
    implements ResponseHandler<HttpResponse> {
        private PreemptiveHttpClientHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public HttpResponse handleResponse(HttpResponse response) throws IOException {
            HttpResponse newResponse = DefaultHttpResponseFactory.INSTANCE.newHttpResponse(response.getStatusLine(), (HttpContext)new HttpClientContext());
            newResponse.setHeaders(response.getAllHeaders());
            int statusCode = response.getStatusLine().getStatusCode();
            if (response.getEntity() != null && statusCode != 500 && statusCode != 405) {
                try {
                    InputStream entityInputStream = IOUtils.toBufferedInputStream((InputStream)response.getEntity().getContent());
                    newResponse.setEntity((HttpEntity)new InputStreamEntity(entityInputStream));
                }
                catch (IOException iOException) {
                }
                catch (NullPointerException nullPointerException) {
                }
                finally {
                    HttpClientUtils.closeQuietly((CloseableHttpResponse)((CloseableHttpResponse)response));
                }
            }
            return newResponse;
        }
    }

    private class PreemptiveRedirectStrategy
    extends DefaultRedirectStrategy {
        private Set<String> redirectableMethods = Sets.newHashSet((Object[])new String[]{"GET".toLowerCase(), "POST".toLowerCase(), "HEAD".toLowerCase(), "DELETE".toLowerCase(), "PUT".toLowerCase()});

        private PreemptiveRedirectStrategy() {
        }

        public HttpUriRequest getRedirect(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
            URI uri = this.getLocationURI(request, response, context);
            PreemptiveHttpClient.this.log.debug("Redirecting to " + uri);
            return RequestBuilder.copy((HttpRequest)request).setUri(uri).build();
        }

        protected boolean isRedirectable(String method) {
            String message = "The method " + method;
            if (this.redirectableMethods.contains(method.toLowerCase())) {
                PreemptiveHttpClient.this.log.debug(message + " can be redirected.");
                return true;
            }
            PreemptiveHttpClient.this.log.error(message + " cannot be redirected.");
            return false;
        }
    }

    private class PreemptiveRetryHandler
    extends DefaultHttpRequestRetryHandler {
        PreemptiveRetryHandler(int connectionRetries) {
            super(connectionRetries, true, (Collection)PreemptiveHttpClient.this.getNonRetriableClasses());
        }

        public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
            PreemptiveHttpClient.this.retryCounter++;
            HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)context);
            PreemptiveHttpClient.this.log.warn("Error occurred for request " + clientContext.getRequest().getRequestLine().toString() + ": " + exception.getMessage() + ".");
            if (PreemptiveHttpClient.this.retryCounter > PreemptiveHttpClient.this.connectionRetries) {
                PreemptiveHttpClient.this.retryCounter = 0;
                return false;
            }
            boolean shouldRetry = super.retryRequest(exception, PreemptiveHttpClient.this.retryCounter, context);
            if (shouldRetry) {
                PreemptiveHttpClient.this.log.warn("Attempting retry #" + PreemptiveHttpClient.this.retryCounter);
                return true;
            }
            PreemptiveHttpClient.this.retryCounter = 0;
            return false;
        }
    }

    private class PreemptiveRetryStrategy
    implements ServiceUnavailableRetryStrategy {
        private PreemptiveRetryStrategy() {
        }

        public boolean retryRequest(HttpResponse response, int executionCount, HttpContext context) {
            PreemptiveHttpClient.this.retryCounter++;
            if (response.getStatusLine().getStatusCode() > 500) {
                HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)context);
                PreemptiveHttpClient.this.log.warn("Error occurred for request " + clientContext.getRequest().getRequestLine().toString() + ". Received status code " + response.getStatusLine().getStatusCode() + " and message: " + response.getStatusLine().getReasonPhrase() + ".");
                if (PreemptiveHttpClient.this.retryCounter <= PreemptiveHttpClient.this.connectionRetries) {
                    PreemptiveHttpClient.this.log.warn("Attempting retry #" + PreemptiveHttpClient.this.retryCounter);
                    return true;
                }
            }
            PreemptiveHttpClient.this.retryCounter = 0;
            return false;
        }

        public long getRetryInterval() {
            return 0L;
        }
    }

    static class PreemptiveAuth
    implements HttpRequestInterceptor {
        PreemptiveAuth() {
        }

        public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
            AuthState authState = (AuthState)context.getAttribute("http.auth.target-scope");
            if (authState.getAuthScheme() == null) {
                AuthScheme authScheme = (AuthScheme)context.getAttribute("preemptive-auth");
                CredentialsProvider credsProvider = (CredentialsProvider)context.getAttribute("http.auth.credentials-provider");
                HttpHost targetHost = (HttpHost)context.getAttribute("http.target_host");
                if (authScheme != null) {
                    Credentials creds = credsProvider.getCredentials(new AuthScope(targetHost.getHostName(), targetHost.getPort()));
                    if (creds == null) {
                        throw new HttpException("No credentials for preemptive authentication");
                    }
                    authState.update(authScheme, creds);
                }
            }
        }
    }
}

