/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.client;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.AuthState;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.jfrog.build.client.ProxyConfiguration;

public class PreemptiveHttpClient {
    private static final String CLIENT_VERSION;
    private CloseableHttpClient httpClient;
    private BasicHttpContext localContext;

    public PreemptiveHttpClient(int timeout) {
        this(null, null, timeout, null);
    }

    public PreemptiveHttpClient(String userName, String password, int timeout) {
        this(userName, password, timeout, null);
    }

    public PreemptiveHttpClient(String userName, String password, int timeout, ProxyConfiguration proxyConfiguration) {
        HttpClientBuilder httpClientBuilder = this.createHttpClientBuilder(userName, password, timeout);
        if (proxyConfiguration != null) {
            this.setProxyConfiguration(httpClientBuilder, proxyConfiguration);
        }
        this.httpClient = httpClientBuilder.build();
    }

    private void setProxyConfiguration(HttpClientBuilder httpClientBuilder, ProxyConfiguration proxyConfiguration) {
        HttpHost proxy = new HttpHost(proxyConfiguration.host, proxyConfiguration.port);
        httpClientBuilder.setProxy(proxy);
        if (proxyConfiguration.username != null) {
            BasicCredentialsProvider basicCredentialsProvider = new BasicCredentialsProvider();
            basicCredentialsProvider.setCredentials(new AuthScope(AuthScope.ANY_HOST, -1), (Credentials)new UsernamePasswordCredentials(proxyConfiguration.username, proxyConfiguration.password));
            httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)basicCredentialsProvider);
        }
    }

    public HttpResponse execute(HttpUriRequest request) throws IOException {
        if (this.localContext != null) {
            return this.httpClient.execute(request, (HttpContext)this.localContext);
        }
        return this.httpClient.execute(request);
    }

    private HttpClientBuilder createHttpClientBuilder(String userName, String password, int timeout) {
        int timeoutMilliSeconds = timeout * 1000;
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(timeoutMilliSeconds).setConnectTimeout(timeoutMilliSeconds).setCircularRedirectsAllowed(true).build();
        HttpClientBuilder builder = HttpClientBuilder.create().setDefaultRequestConfig(requestConfig);
        if (userName != null && !"".equals(userName)) {
            BasicCredentialsProvider basicCredentialsProvider = new BasicCredentialsProvider();
            basicCredentialsProvider.setCredentials(new AuthScope(AuthScope.ANY_HOST, -1), (Credentials)new UsernamePasswordCredentials(userName, password));
            builder.setDefaultCredentialsProvider((CredentialsProvider)basicCredentialsProvider);
            this.localContext = new BasicHttpContext();
            BasicScheme basicAuth = new BasicScheme();
            this.localContext.setAttribute("preemptive-auth", (Object)basicAuth);
            builder.addInterceptorFirst((HttpRequestInterceptor)new PreemptiveAuth());
        }
        String userAgent = "ArtifactoryBuildClient/" + CLIENT_VERSION;
        builder.setUserAgent(userAgent);
        return builder;
    }

    public void close() {
        try {
            this.httpClient.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static {
        Properties properties = new Properties();
        InputStream is = PreemptiveHttpClient.class.getResourceAsStream("/bi.client.properties");
        if (is != null) {
            try {
                properties.load(is);
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        CLIENT_VERSION = properties.getProperty("client.version", "unknown");
    }

    static class PreemptiveAuth
    implements HttpRequestInterceptor {
        PreemptiveAuth() {
        }

        public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
            AuthState authState = (AuthState)context.getAttribute("http.auth.target-scope");
            if (authState.getAuthScheme() == null) {
                AuthScheme authScheme = (AuthScheme)context.getAttribute("preemptive-auth");
                CredentialsProvider credsProvider = (CredentialsProvider)context.getAttribute("http.auth.credentials-provider");
                HttpHost targetHost = (HttpHost)context.getAttribute("http.target_host");
                if (authScheme != null) {
                    Credentials creds = credsProvider.getCredentials(new AuthScope(targetHost.getHostName(), targetHost.getPort()));
                    if (creds == null) {
                        throw new HttpException("No credentials for preemptive authentication");
                    }
                    authState.update(authScheme, creds);
                }
            }
        }
    }
}

