/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.client;

import java.io.IOException;
import java.io.InputStream;
import java.util.BitSet;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.commons.codec.net.URLCodec;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.ObjectCodec;
import org.codehaus.jackson.map.AnnotationIntrospector;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.codehaus.jackson.map.introspect.JacksonAnnotationIntrospector;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.client.ArtifactoryUploadResponse;
import org.jfrog.build.client.ArtifactoryVersion;
import org.jfrog.build.client.PreemptiveHttpClient;
import org.jfrog.build.client.ProxyConfiguration;
import org.jfrog.build.util.URI;

public class ArtifactoryHttpClient {
    public static final ArtifactoryVersion UNKNOWN_PROPERTIES_TOLERANT_ARTIFACTORY_VERSION = new ArtifactoryVersion("2.2.3");
    public static final ArtifactoryVersion NON_NUMERIC_BUILD_NUMBERS_TOLERANT_ARTIFACTORY_VERSION = new ArtifactoryVersion("2.2.4");
    public static final ArtifactoryVersion MINIMAL_ARTIFACTORY_VERSION = new ArtifactoryVersion("2.2.3");
    public static final String VERSION_INFO_URL = "/api/system/version";
    private static final int DEFAULT_CONNECTION_TIMEOUT_SECS = 300;
    private final Log log;
    private final String artifactoryUrl;
    private final String username;
    private final String password;
    private int connectionTimeout = 300;
    private ProxyConfiguration proxyConfiguration;
    private PreemptiveHttpClient deployClient;

    public ArtifactoryHttpClient(String artifactoryUrl, String username, String password, Log log) {
        this.artifactoryUrl = org.apache.commons.lang.StringUtils.stripEnd((String)artifactoryUrl, (String)"/");
        this.username = username;
        this.password = password;
        this.log = log;
    }

    public static String encodeUrl(String unescaped) {
        byte[] rawdata = URLCodec.encodeUrl((BitSet)URI.allowed_query, (byte[])StringUtils.getBytesUtf8((String)unescaped));
        return StringUtils.newStringUsAscii((byte[])rawdata);
    }

    public void setProxyConfiguration(String host, int port) {
        this.setProxyConfiguration(host, port, null, null);
    }

    public void setProxyConfiguration(String host, int port, String username, String password) {
        this.proxyConfiguration = new ProxyConfiguration();
        this.proxyConfiguration.host = host;
        this.proxyConfiguration.port = port;
        this.proxyConfiguration.username = username;
        this.proxyConfiguration.password = password;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public void shutdown() {
        if (this.deployClient != null) {
            this.deployClient.shutdown();
        }
    }

    public PreemptiveHttpClient getHttpClient() {
        if (this.deployClient == null) {
            PreemptiveHttpClient client = new PreemptiveHttpClient(this.username, this.password, this.connectionTimeout);
            if (this.proxyConfiguration != null) {
                client.setProxyConfiguration(this.proxyConfiguration.host, this.proxyConfiguration.port, this.proxyConfiguration.username, this.proxyConfiguration.password);
            }
            this.deployClient = client;
        }
        return this.deployClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArtifactoryVersion getVersion() throws IOException {
        HttpGet httpGet;
        String versionUrl = this.artifactoryUrl + VERSION_INFO_URL;
        PreemptiveHttpClient client = this.getHttpClient();
        HttpResponse response = client.execute((HttpUriRequest)(httpGet = new HttpGet(versionUrl)));
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode == 404) {
            HttpEntity httpEntity = response.getEntity();
            if (httpEntity != null) {
                EntityUtils.consume((HttpEntity)httpEntity);
            }
            return ArtifactoryVersion.NOT_FOUND;
        }
        if (statusCode != 200) {
            if (response.getEntity() != null) {
                EntityUtils.consume((HttpEntity)response.getEntity());
            }
            throw new IOException(response.getStatusLine().getReasonPhrase());
        }
        HttpEntity httpEntity = response.getEntity();
        if (httpEntity != null) {
            InputStream content = httpEntity.getContent();
            try {
                JsonParser parser = this.createJsonParser(content);
                EntityUtils.consume((HttpEntity)httpEntity);
                JsonNode result = parser.readValueAsTree();
                this.log.debug("Version result: " + result);
                String version = result.get("version").getTextValue();
                JsonNode addonsNode = result.get("addons");
                boolean hasAddons = addonsNode != null && addonsNode.iterator().hasNext();
                ArtifactoryVersion artifactoryVersion = new ArtifactoryVersion(version, hasAddons);
                return artifactoryVersion;
            }
            finally {
                if (content != null) {
                    content.close();
                }
            }
        }
        return ArtifactoryVersion.NOT_FOUND;
    }

    public JsonParser createJsonParser(InputStream in) throws IOException {
        JsonFactory jsonFactory = this.createJsonFactory();
        return jsonFactory.createJsonParser(in);
    }

    public JsonParser createJsonParser(String content) throws IOException {
        JsonFactory jsonFactory = this.createJsonFactory();
        return jsonFactory.createJsonParser(content);
    }

    public JsonFactory createJsonFactory() {
        JsonFactory jsonFactory = new JsonFactory();
        ObjectMapper mapper = new ObjectMapper(jsonFactory);
        mapper.getSerializationConfig().setAnnotationIntrospector((AnnotationIntrospector)new JacksonAnnotationIntrospector());
        mapper.getSerializationConfig().setSerializationInclusion(JsonSerialize.Inclusion.NON_NULL);
        jsonFactory.setCodec((ObjectCodec)mapper);
        return jsonFactory;
    }

    public ArtifactoryUploadResponse upload(HttpPut httpPut, HttpEntity fileEntity) throws IOException {
        httpPut.setEntity(fileEntity);
        return this.execute(httpPut);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArtifactoryUploadResponse execute(HttpPut httpPut) throws IOException {
        InputStream in;
        HttpResponse response = this.getHttpClient().execute((HttpUriRequest)httpPut);
        ArtifactoryUploadResponse artifactoryResponse = null;
        StatusLine statusLine = response.getStatusLine();
        HttpEntity entity = response.getEntity();
        if (entity != null && (in = entity.getContent()) != null) {
            String content = IOUtils.toString((InputStream)in, (String)"UTF-8");
            try {
                JsonParser parser = this.createJsonParser(content);
                artifactoryResponse = (ArtifactoryUploadResponse)parser.readValueAs(ArtifactoryUploadResponse.class);
            }
            catch (Exception e) {
                this.log.error("Failed while reading the response from: " + httpPut, (Throwable)e);
            }
            finally {
                in.close();
            }
        }
        if (artifactoryResponse == null) {
            artifactoryResponse = new ArtifactoryUploadResponse();
        }
        artifactoryResponse.setStatusLine(statusLine);
        return artifactoryResponse;
    }
}

