/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.client;

import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.jfrog.build.api.util.Log;

public class PrefixPropertyHandler {
    protected final Map<String, String> props;
    protected final Log log;
    private final String prefix;

    public PrefixPropertyHandler(Log log, Map<String, String> props) {
        this(log, props, "");
    }

    public PrefixPropertyHandler(PrefixPropertyHandler root, String prefix) {
        this(root.log, root.props, prefix);
    }

    private PrefixPropertyHandler(Log log, Map<String, String> props, String prefix) {
        this.log = log;
        this.props = props;
        this.prefix = prefix;
    }

    public Log getLog() {
        return this.log;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getStringValue(String key) {
        return this.getStringValue(key, null);
    }

    public String getStringValue(String key, String def) {
        String s = this.props.get(this.prefix + key);
        if (s == null) {
            s = def;
        }
        return s;
    }

    public void setStringValue(String key, String value) {
        if (value == null) {
            this.props.remove(this.prefix + key);
        } else {
            this.props.put(this.prefix + key, value);
        }
    }

    public Boolean getBooleanValue(String key, Boolean def) {
        Boolean result;
        String s = this.props.get(this.prefix + key);
        Boolean bl = result = s == null ? null : Boolean.valueOf(Boolean.parseBoolean(s));
        if (result == null) {
            result = def;
        }
        return result;
    }

    public void setBooleanValue(String key, Boolean value) {
        if (value == null) {
            this.props.remove(this.prefix + key);
        } else {
            this.props.put(this.prefix + key, value.toString());
        }
    }

    public Integer getIntegerValue(String key) {
        return this.getIntegerValue(key, null);
    }

    public Integer getIntegerValue(String key, Integer def) {
        Integer result;
        String s = this.props.get(this.prefix + key);
        if (s != null && !StringUtils.isNumeric((String)s)) {
            this.log.debug("Property '" + this.prefix + key + "' is not of numeric value '" + s + "'");
            result = null;
        } else {
            Integer n = result = s == null ? null : Integer.valueOf(Integer.parseInt(s));
        }
        if (result == null) {
            result = def;
        }
        return result;
    }

    public void setIntegerValue(String key, Integer value) {
        if (value == null) {
            this.props.remove(this.prefix + key);
        } else {
            this.props.put(this.prefix + key, value.toString());
        }
    }
}

